/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.BodyFilters;
import org.zalando.logbook.DefaultHttpLogFormatter;
import org.zalando.logbook.DefaultHttpLogWriter;
import org.zalando.logbook.DefaultLogbook;
import org.zalando.logbook.FilteredHttpRequest;
import org.zalando.logbook.FilteredHttpResponse;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HeaderFilters;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.LogbookFactory;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.QueryFilters;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawRequestFilter;
import org.zalando.logbook.RawRequestFilters;
import org.zalando.logbook.RawResponseFilter;
import org.zalando.logbook.RawResponseFilters;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;

@API(status=API.Status.INTERNAL)
public final class DefaultLogbookFactory
implements LogbookFactory {
    public Logbook create(@Nullable Predicate<RawHttpRequest> nullableCondition, @Nullable RawRequestFilter nullableRawRequestFilter, @Nullable RawResponseFilter nullableRawResponseFilter, @Nullable QueryFilter queryFilter, @Nullable HeaderFilter headerFilter, @Nullable BodyFilter bodyFilter, @Nullable RequestFilter requestFilter, @Nullable ResponseFilter responseFilter, @Nullable HttpLogFormatter formatter, @Nullable HttpLogWriter writer) {
        Predicate<RawHttpRequest> condition = Optional.ofNullable(nullableCondition).orElse($ -> true);
        HeaderFilter header = Optional.ofNullable(headerFilter).orElseGet(HeaderFilters::defaultValue);
        BodyFilter body = Optional.ofNullable(bodyFilter).orElseGet(BodyFilters::defaultValue);
        RawRequestFilter rawRequestFilter = Optional.ofNullable(nullableRawRequestFilter).orElseGet(RawRequestFilters::defaultValue);
        RawResponseFilter rawResponseFilter = Optional.ofNullable(nullableRawResponseFilter).orElseGet(RawResponseFilters::defaultValue);
        return new DefaultLogbook(condition, rawRequestFilter, rawResponseFilter, this.combine(queryFilter, header, body, requestFilter), this.combine(header, body, responseFilter), Optional.ofNullable(formatter).orElseGet(DefaultHttpLogFormatter::new), Optional.ofNullable(writer).orElseGet(DefaultHttpLogWriter::new));
    }

    @Nonnull
    private RequestFilter combine(@Nullable QueryFilter queryFilter, HeaderFilter headerFilter, BodyFilter bodyFilter, @Nullable RequestFilter requestFilter) {
        QueryFilter query = Optional.ofNullable(queryFilter).orElseGet(QueryFilters::defaultValue);
        return RequestFilter.merge((RequestFilter)Optional.ofNullable(requestFilter).orElseGet(RequestFilter::none), request -> new FilteredHttpRequest(request, query, headerFilter, bodyFilter));
    }

    @Nonnull
    private ResponseFilter combine(HeaderFilter headerFilter, BodyFilter bodyFilter, @Nullable ResponseFilter responseFilter) {
        return ResponseFilter.merge((ResponseFilter)Optional.ofNullable(responseFilter).orElseGet(ResponseFilter::none), response -> new FilteredHttpResponse(response, headerFilter, bodyFilter));
    }
}

