/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.logbook.BaseHttpRequest;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ForwardingHttpRequest;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.RequestURI;

@API(status=API.Status.INTERNAL)
public final class FilteredHttpRequest
implements ForwardingHttpRequest {
    private final HttpRequest request;
    private final QueryFilter queryFilter;
    private final BodyFilter bodyFilter;
    private final Map<String, List<String>> headers;

    FilteredHttpRequest(HttpRequest request, QueryFilter queryFilter, HeaderFilter headerFilter, BodyFilter bodyFilter) {
        this.request = request;
        this.queryFilter = queryFilter;
        this.bodyFilter = bodyFilter;
        this.headers = headerFilter.filter(request.getHeaders());
    }

    public HttpRequest delegate() {
        return this.request;
    }

    public String getRequestUri() {
        return RequestURI.reconstruct((BaseHttpRequest)this);
    }

    public String getQuery() {
        String query = this.request.getQuery();
        return query.isEmpty() ? query : this.queryFilter.filter(query);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() throws IOException {
        return this.getBodyAsString().getBytes(this.getCharset());
    }

    public String getBodyAsString() throws IOException {
        return this.bodyFilter.filter(this.getContentType(), this.request.getBodyAsString());
    }
}

