/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ForwardingHttpResponse;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpResponse;

@API(status=API.Status.INTERNAL)
public final class FilteredHttpResponse
implements ForwardingHttpResponse {
    private final HttpResponse response;
    private final BodyFilter bodyFilter;
    private final Map<String, List<String>> headers;

    FilteredHttpResponse(HttpResponse response, HeaderFilter headerFilter, BodyFilter bodyFilter) {
        this.response = response;
        this.bodyFilter = bodyFilter;
        this.headers = headerFilter.filter(response.getHeaders());
    }

    public HttpResponse delegate() {
        return this.response;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() throws IOException {
        return this.getBodyAsString().getBytes(this.getCharset());
    }

    public String getBodyAsString() throws IOException {
        return this.bodyFilter.filter(this.response.getContentType(), this.response.getBodyAsString());
    }
}

