/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.logbook.BaseHttpMessage;
import org.zalando.logbook.HeaderFilter;

@API(status=API.Status.STABLE)
public final class HeaderFilters {
    private HeaderFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static HeaderFilter defaultValue() {
        return HeaderFilters.authorization();
    }

    @API(status=API.Status.MAINTAINED)
    public static HeaderFilter authorization() {
        return HeaderFilters.replaceHeaders("Authorization"::equalsIgnoreCase, "XXX");
    }

    public static HeaderFilter replaceHeaders(Predicate<String> keyPredicate, String replacement) {
        return HeaderFilters.eachHeader((key, value) -> keyPredicate.test((String)key) ? replacement : value);
    }

    public static HeaderFilter replaceHeaders(BiPredicate<String, String> predicate, String replacement) {
        return HeaderFilters.eachHeader((key, value) -> predicate.test((String)key, (String)value) ? replacement : value);
    }

    public static HeaderFilter eachHeader(BinaryOperator<String> operator) {
        return headers -> {
            BaseHttpMessage.HeadersBuilder result = new BaseHttpMessage.HeadersBuilder();
            headers.forEach((key, values) -> values.stream().map(value -> (String)operator.apply((String)key, value)).forEach(value -> result.put(key, value)));
            return result.build();
        };
    }

    public static HeaderFilter removeHeaders(Predicate<String> keyPredicate) {
        return HeaderFilters.removeHeaders((String key, String value) -> keyPredicate.test((String)key));
    }

    public static HeaderFilter removeHeaders(BiPredicate<String, String> predicate) {
        return headers -> {
            BaseHttpMessage.HeadersBuilder result = new BaseHttpMessage.HeadersBuilder();
            headers.forEach((key, values) -> values.stream().filter(value -> !predicate.test((String)key, (String)value)).forEach(value -> result.put(key, value)));
            return result.build();
        };
    }
}

