/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.regex.Pattern;

final class JsonHeuristic {
    private final Pattern number = Pattern.compile("^-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+-]?[0-9]+)?$");

    JsonHeuristic() {
    }

    boolean isProbablyJson(String body) {
        return this.isNull(body) || this.isBoolean(body) || this.isNumber(body) || this.isProbablyString(body) || this.isProbablyArray(body) || this.isProbablyObject(body);
    }

    private boolean isNull(String body) {
        return "null".equals(body);
    }

    private boolean isBoolean(String body) {
        return "true".equals(body) || "false".equals(body);
    }

    private boolean isNumber(String body) {
        return this.number.matcher(body).matches();
    }

    private boolean isProbablyString(String body) {
        return body.startsWith("\"") && body.endsWith("\"") && body.length() > 1;
    }

    private boolean isProbablyArray(String body) {
        return body.startsWith("[") && body.endsWith("]");
    }

    private boolean isProbablyObject(String body) {
        return body.startsWith("{") && body.endsWith("}");
    }
}

