/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.JsonCompactor;
import org.zalando.logbook.JsonHeuristic;
import org.zalando.logbook.MediaTypeQuery;
import org.zalando.logbook.Origins;
import org.zalando.logbook.Precorrelation;

@API(status=API.Status.STABLE)
public final class JsonHttpLogFormatter
implements HttpLogFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHttpLogFormatter.class);
    private static final Predicate<String> JSON = MediaTypeQuery.compile("application/json", "application/*+json");
    private final ObjectMapper mapper;
    private final JsonHeuristic heuristic = new JsonHeuristic();
    private final JsonCompactor compactor;

    public JsonHttpLogFormatter() {
        this(new ObjectMapper());
    }

    public JsonHttpLogFormatter(ObjectMapper mapper) {
        this.mapper = mapper;
        this.compactor = new JsonCompactor(mapper);
    }

    public String format(Precorrelation<HttpRequest> precorrelation) throws IOException {
        return this.format(this.prepare(precorrelation));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public Map<String, Object> prepare(Precorrelation<HttpRequest> precorrelation) throws IOException {
        String correlationId = precorrelation.getId();
        HttpRequest request = (HttpRequest)precorrelation.getRequest();
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("origin", Origins.translate(request.getOrigin()));
        content.put("type", "request");
        content.put("correlation", correlationId);
        content.put("protocol", request.getProtocolVersion());
        content.put("remote", request.getRemote());
        content.put("method", request.getMethod());
        content.put("uri", request.getRequestUri());
        JsonHttpLogFormatter.addUnless(content, "headers", request.getHeaders(), Map::isEmpty);
        this.addBody((HttpMessage)request, content);
        return content;
    }

    public String format(Correlation<HttpRequest, HttpResponse> correlation) throws IOException {
        return this.format(this.prepare(correlation));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public Map<String, Object> prepare(Correlation<HttpRequest, HttpResponse> correlation) throws IOException {
        HttpResponse response = (HttpResponse)correlation.getResponse();
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("origin", Origins.translate(response.getOrigin()));
        content.put("type", "response");
        content.put("correlation", correlation.getId());
        content.put("duration", correlation.getDuration().toMillis());
        content.put("protocol", response.getProtocolVersion());
        content.put("status", response.getStatus());
        JsonHttpLogFormatter.addUnless(content, "headers", response.getHeaders(), Map::isEmpty);
        this.addBody((HttpMessage)response, content);
        return content;
    }

    private static <T> void addUnless(Map<String, Object> target, String key, T element, Predicate<T> predicate) {
        if (!predicate.test(element)) {
            target.put(key, element);
        }
    }

    private void addBody(HttpMessage message, Map<String, Object> map) throws IOException {
        String body = message.getBodyAsString();
        if (this.isContentTypeJson(message)) {
            map.put("body", this.tryParseBodyAsJson(body));
        } else {
            JsonHttpLogFormatter.addUnless(map, "body", body, String::isEmpty);
        }
    }

    private boolean isContentTypeJson(HttpMessage message) {
        return JSON.test(message.getContentType());
    }

    private Object tryParseBodyAsJson(String body) {
        if (this.heuristic.isProbablyJson(body)) {
            if (this.compactor.isCompacted(body)) {
                return new JsonBody(body);
            }
            try {
                return new JsonBody(this.compactor.compact(body));
            }
            catch (IOException e) {
                LOG.trace("Unable to compact body, probably because it's not JSON. Embedding it as-is: [{}]", (Object)e.getMessage());
                return body;
            }
        }
        return body;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public String format(Map<String, Object> content) throws IOException {
        return this.mapper.writeValueAsString(content);
    }

    private static final class JsonBody {
        String json;

        @JsonRawValue
        @JsonValue
        public String getJson() {
            return this.json;
        }

        public JsonBody(String json) {
            this.json = json;
        }
    }
}

