/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.zalando.logbook.QueryFilter;

@API(status=API.Status.STABLE)
public final class QueryFilters {
    private QueryFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter defaultValue() {
        return QueryFilters.accessToken();
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter accessToken() {
        return QueryFilters.replaceQuery("access_token", "XXX");
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter replaceQuery(String name, String replacement) {
        Pattern pattern = Pattern.compile("((?:^|&)" + Pattern.quote(name) + "=)(?:.*?)(&|$)");
        String replacementPattern = "$1" + replacement + "$2";
        return query -> pattern.matcher(query).replaceAll(replacementPattern);
    }
}

