/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.RawRequestFilter;
import org.zalando.logbook.servlet.Attributes;
import org.zalando.logbook.servlet.LocalResponse;
import org.zalando.logbook.servlet.RemoteRequest;
import org.zalando.logbook.servlet.Strategy;

final class NormalStrategy
implements Strategy {
    private final RawRequestFilter filter;

    NormalStrategy(RawRequestFilter filter) {
        this.filter = filter;
    }

    @Override
    public void doFilter(Logbook logbook, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws ServletException, IOException {
        RemoteRequest request = new RemoteRequest(httpRequest);
        Optional<Correlator> correlator = this.logRequestIfNecessary(logbook, request);
        if (correlator.isPresent()) {
            String protocolVersion = request.getProtocolVersion();
            LocalResponse response = new LocalResponse(httpResponse, protocolVersion);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            this.logResponse(correlator.get(), request, response);
        } else {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private Optional<Correlator> logRequestIfNecessary(Logbook logbook, RemoteRequest request) throws IOException {
        if (this.isFirstRequest((HttpServletRequest)request)) {
            Optional correlator = logbook.write(this.skipBodyIfErrorDispatch(request));
            correlator.ifPresent(this.writeCorrelator(request));
            return correlator;
        }
        return this.readCorrelator(request);
    }

    private RawHttpRequest skipBodyIfErrorDispatch(RemoteRequest request) {
        if (request.getAttribute("javax.servlet.error.exception_type") == null) {
            return request;
        }
        return this.filter.filter((RawHttpRequest)request);
    }

    private Consumer<Correlator> writeCorrelator(RemoteRequest request) {
        return correlator -> request.setAttribute(Attributes.CORRELATOR, correlator);
    }

    private Optional<Correlator> readCorrelator(RemoteRequest request) {
        return Optional.ofNullable(request.getAttribute(Attributes.CORRELATOR)).map(Correlator.class::cast);
    }

    private void logResponse(Correlator correlator, RemoteRequest request, LocalResponse response) throws IOException {
        if (this.isLastRequest((HttpServletRequest)request)) {
            response.getWriter().flush();
            correlator.write((RawHttpResponse)response);
        }
    }
}

