/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Logger;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.http.client.HttpClient;
import org.apiguardian.api.API;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.security.web.SecurityFilterChain;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.CorrelationId;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.PathFilter;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;
import org.zalando.logbook.Sink;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.autoconfigure.LogbookProperties;
import org.zalando.logbook.core.BodyFilters;
import org.zalando.logbook.core.BodyOnlyIfStatusAtLeastStrategy;
import org.zalando.logbook.core.ChunkingSink;
import org.zalando.logbook.core.Conditions;
import org.zalando.logbook.core.CurlHttpLogFormatter;
import org.zalando.logbook.core.DefaultCorrelationId;
import org.zalando.logbook.core.DefaultHttpLogFormatter;
import org.zalando.logbook.core.DefaultHttpLogWriter;
import org.zalando.logbook.core.DefaultSink;
import org.zalando.logbook.core.DefaultStrategy;
import org.zalando.logbook.core.HeaderFilters;
import org.zalando.logbook.core.PathFilters;
import org.zalando.logbook.core.QueryFilters;
import org.zalando.logbook.core.RequestFilters;
import org.zalando.logbook.core.ResponseFilters;
import org.zalando.logbook.core.SplunkHttpLogFormatter;
import org.zalando.logbook.core.StatusAtLeastStrategy;
import org.zalando.logbook.core.WithoutBodyStrategy;
import org.zalando.logbook.httpclient.LogbookHttpRequestInterceptor;
import org.zalando.logbook.httpclient.LogbookHttpResponseInterceptor;
import org.zalando.logbook.json.JsonHttpLogFormatter;
import org.zalando.logbook.openfeign.FeignLogbookLogger;
import org.zalando.logbook.servlet.FormRequestMode;
import org.zalando.logbook.servlet.SecureLogbookFilter;
import org.zalando.logbook.servlet.javax.LogbookFilter;
import org.zalando.logbook.spring.LogbookClientHttpRequestInterceptor;

@API(status=API.Status.STABLE)
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Logbook.class})
@EnableConfigurationProperties(value={LogbookProperties.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class}, name={"org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration"})
public class LogbookAutoConfiguration {
    private final LogbookProperties properties;

    @API(status=API.Status.INTERNAL)
    @Autowired
    public LogbookAutoConfiguration(LogbookProperties properties) {
        this.properties = properties;
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={Logbook.class})
    public Logbook logbook(Predicate<HttpRequest> condition, CorrelationId correlationId, List<HeaderFilter> headerFilters, List<PathFilter> pathFilters, List<QueryFilter> queryFilters, List<BodyFilter> bodyFilters, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, Strategy strategy, Sink sink) {
        return Logbook.builder().condition(this.mergeWithExcludes(this.mergeWithIncludes(condition))).correlationId(correlationId).headerFilters(headerFilters).queryFilters(queryFilters).pathFilters(pathFilters).bodyFilters(bodyFilters).requestFilters(requestFilters).responseFilters(responseFilters).strategy(strategy).sink(sink).build();
    }

    private Predicate<HttpRequest> mergeWithExcludes(Predicate<HttpRequest> predicate) {
        return this.properties.getExclude().stream().map(Conditions::requestTo).map(Predicate::negate).reduce(predicate, Predicate::and);
    }

    private Predicate<HttpRequest> mergeWithIncludes(Predicate<HttpRequest> predicate) {
        return this.properties.getInclude().stream().map(Conditions::requestTo).reduce(Predicate::or).map(predicate::and).orElse(predicate);
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(name={"requestCondition"})
    public Predicate<HttpRequest> requestCondition() {
        return $ -> true;
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={CorrelationId.class})
    public CorrelationId correlationId() {
        return new DefaultCorrelationId();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={QueryFilter.class})
    public QueryFilter queryFilter() {
        List<String> parameters = this.properties.getObfuscate().getParameters();
        return parameters.isEmpty() ? QueryFilters.defaultValue() : QueryFilters.replaceQuery(new HashSet<String>(parameters)::contains, (String)"XXX");
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={HeaderFilter.class})
    public HeaderFilter headerFilter() {
        TreeSet<String> headers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        headers.addAll(this.properties.getObfuscate().getHeaders());
        return headers.isEmpty() ? HeaderFilters.defaultValue() : HeaderFilters.replaceHeaders(headers, (String)"XXX");
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={PathFilter.class})
    public PathFilter pathFilter() {
        List<String> paths = this.properties.getObfuscate().getPaths();
        return paths.isEmpty() ? PathFilter.none() : paths.stream().map(path -> PathFilters.replace((String)path, (String)"XXX")).reduce(PathFilter::merge).orElseGet(PathFilter::none);
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={BodyFilter.class})
    public BodyFilter bodyFilter() {
        LogbookProperties.Write write = this.properties.getWrite();
        int maxBodySize = write.getMaxBodySize();
        if (maxBodySize < 0) {
            return BodyFilters.defaultValue();
        }
        return BodyFilter.merge((BodyFilter)BodyFilters.defaultValue(), (BodyFilter)BodyFilters.truncate((int)maxBodySize));
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={RequestFilter.class})
    public RequestFilter requestFilter() {
        return RequestFilters.defaultValue();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={ResponseFilter.class})
    public ResponseFilter responseFilter() {
        return ResponseFilters.defaultValue();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={Strategy.class})
    @ConditionalOnProperty(name={"logbook.strategy"}, havingValue="default", matchIfMissing=true)
    public Strategy strategy() {
        return new DefaultStrategy();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={Strategy.class})
    @ConditionalOnProperty(name={"logbook.strategy"}, havingValue="status-at-least")
    public Strategy statusAtLeastStrategy(@Value(value="${logbook.minimum-status:400}") int status) {
        return new StatusAtLeastStrategy(status);
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={Strategy.class})
    @ConditionalOnProperty(name={"logbook.strategy"}, havingValue="body-only-if-status-at-least")
    public Strategy bodyOnlyIfStatusAtLeastStrategy(@Value(value="${logbook.minimum-status:400}") int status) {
        return new BodyOnlyIfStatusAtLeastStrategy(status);
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={Strategy.class})
    @ConditionalOnProperty(name={"logbook.strategy"}, havingValue="without-body")
    public Strategy withoutBody() {
        return new WithoutBodyStrategy();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={Sink.class})
    public Sink sink(HttpLogFormatter formatter, HttpLogWriter writer) {
        return new DefaultSink(formatter, writer);
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @Primary
    @ConditionalOnBean(value={Sink.class})
    @ConditionalOnProperty(value={"logbook.write.chunk-size"})
    public Sink chunkingSink(Sink sink) {
        return new ChunkingSink(sink, this.properties.getWrite().getChunkSize());
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={HttpLogFormatter.class})
    @ConditionalOnProperty(name={"logbook.format.style"}, havingValue="http")
    public HttpLogFormatter httpFormatter() {
        return new DefaultHttpLogFormatter();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={HttpLogFormatter.class})
    @ConditionalOnProperty(name={"logbook.format.style"}, havingValue="curl")
    public HttpLogFormatter curlFormatter() {
        return new CurlHttpLogFormatter();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={HttpLogFormatter.class})
    @ConditionalOnProperty(name={"logbook.format.style"}, havingValue="splunk")
    public HttpLogFormatter splunkHttpLogFormatter() {
        return new SplunkHttpLogFormatter();
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={HttpLogFormatter.class})
    public HttpLogFormatter jsonFormatter(ObjectMapper mapper) {
        return new JsonHttpLogFormatter(mapper);
    }

    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnMissingBean(value={HttpLogWriter.class})
    public HttpLogWriter writer() {
        return new DefaultHttpLogWriter();
    }

    @Bean
    @ConditionalOnMissingBean(value={LogbookClientHttpRequestInterceptor.class})
    public LogbookClientHttpRequestInterceptor logbookClientHttpRequestInterceptor(Logbook logbook) {
        return new LogbookClientHttpRequestInterceptor(logbook);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Logger.class, FeignLogbookLogger.class})
    static class FeignLogbookLoggerConfiguration {
        FeignLogbookLoggerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Logger.class})
        public Logger feignLogbookLogger(Logbook logbook) {
            return new FeignLogbookLogger(logbook);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SecurityFilterChain.class, javax.servlet.Servlet.class, LogbookFilter.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.security.servlet.SecurityFilterAutoConfiguration"})
    static class JavaxSecurityServletFilterConfiguration {
        private static final String FILTER_NAME = "secureLogbookFilter";

        JavaxSecurityServletFilterConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.secure-filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"secureLogbookFilter"})
        @Order(value=-2147483647)
        public org.zalando.logbook.servlet.javax.SecureLogbookFilter secureLogbookFilter(Logbook logbook) {
            return new org.zalando.logbook.servlet.javax.SecureLogbookFilter(logbook);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SecurityFilterChain.class, Servlet.class, org.zalando.logbook.servlet.LogbookFilter.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.security.servlet.SecurityFilterAutoConfiguration"})
    static class JakartaSecurityServletFilterConfiguration {
        private static final String FILTER_NAME = "secureLogbookFilter";

        JakartaSecurityServletFilterConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.secure-filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"secureLogbookFilter"})
        public FilterRegistrationBean secureLogbookFilter(Logbook logbook) {
            return JakartaServletFilterConfiguration.newFilter((Filter)new SecureLogbookFilter(logbook), FILTER_NAME, -2147483647);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={javax.servlet.Servlet.class, LogbookFilter.class})
    static class JavaxServletFilterConfiguration {
        private static final String FILTER_NAME = "logbookFilter";
        private final LogbookProperties properties;

        @API(status=API.Status.INTERNAL)
        @Autowired
        public JavaxServletFilterConfiguration(LogbookProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"logbookFilter"})
        public LogbookFilter logbookFilter(Logbook logbook) {
            FormRequestMode fromProperties = this.properties.getFilter().getFormRequestMode();
            org.zalando.logbook.servlet.javax.FormRequestMode formRequestMode = org.zalando.logbook.servlet.javax.FormRequestMode.valueOf((String)fromProperties.name());
            return new LogbookFilter(logbook).withFormRequestMode(formRequestMode);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={Servlet.class, org.zalando.logbook.servlet.LogbookFilter.class})
    static class JakartaServletFilterConfiguration {
        private static final String FILTER_NAME = "logbookFilter";
        private final LogbookProperties properties;

        @API(status=API.Status.INTERNAL)
        @Autowired
        public JakartaServletFilterConfiguration(LogbookProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"logbookFilter"})
        public FilterRegistrationBean logbookFilter(Logbook logbook) {
            org.zalando.logbook.servlet.LogbookFilter filter = new org.zalando.logbook.servlet.LogbookFilter(logbook).withFormRequestMode(this.properties.getFilter().getFormRequestMode());
            return JakartaServletFilterConfiguration.newFilter((Filter)filter, FILTER_NAME, Integer.MAX_VALUE);
        }

        static FilterRegistrationBean newFilter(Filter filter, String filterName, int order) {
            FilterRegistrationBean registration = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
            registration.setName(filterName);
            registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
            registration.setOrder(order);
            return registration;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={org.apache.hc.client5.http.classic.HttpClient.class, org.zalando.logbook.httpclient5.LogbookHttpRequestInterceptor.class, org.zalando.logbook.httpclient5.LogbookHttpResponseInterceptor.class})
    static class HttpClient5AutoConfiguration {
        HttpClient5AutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={org.zalando.logbook.httpclient5.LogbookHttpRequestInterceptor.class})
        public org.zalando.logbook.httpclient5.LogbookHttpRequestInterceptor logbookHttpClient5RequestInterceptor(Logbook logbook) {
            return new org.zalando.logbook.httpclient5.LogbookHttpRequestInterceptor(logbook);
        }

        @Bean
        @ConditionalOnMissingBean(value={org.zalando.logbook.httpclient5.LogbookHttpResponseInterceptor.class})
        public org.zalando.logbook.httpclient5.LogbookHttpResponseInterceptor logbookHttpClient5ResponseInterceptor() {
            return new org.zalando.logbook.httpclient5.LogbookHttpResponseInterceptor();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class, LogbookHttpRequestInterceptor.class, LogbookHttpResponseInterceptor.class})
    static class HttpClientAutoConfiguration {
        HttpClientAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={LogbookHttpRequestInterceptor.class})
        public LogbookHttpRequestInterceptor logbookHttpRequestInterceptor(Logbook logbook) {
            return new LogbookHttpRequestInterceptor(logbook);
        }

        @Bean
        @ConditionalOnMissingBean(value={LogbookHttpResponseInterceptor.class})
        public LogbookHttpResponseInterceptor logbookHttpResponseInterceptor(@Value(value="${logbook.httpclient.decompress-response:false}") boolean decompressResponse) {
            return new LogbookHttpResponseInterceptor(decompressResponse);
        }
    }
}

