/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.MessageLogger;
import org.zeroturnaround.exec.MessageLoggers;
import org.zeroturnaround.exec.ProcessAttributes;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.WaitForProcess;
import org.zeroturnaround.exec.listener.CompositeProcessListener;
import org.zeroturnaround.exec.listener.DestroyerListenerAdapter;
import org.zeroturnaround.exec.listener.ProcessDestroyer;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.listener.ShutdownHookProcessDestroyer;
import org.zeroturnaround.exec.stop.DestroyProcessStopper;
import org.zeroturnaround.exec.stop.NopProcessStopper;
import org.zeroturnaround.exec.stop.ProcessStopper;
import org.zeroturnaround.exec.stream.CallerLoggerUtil;
import org.zeroturnaround.exec.stream.ExecuteStreamHandler;
import org.zeroturnaround.exec.stream.PumpStreamHandler;
import org.zeroturnaround.exec.stream.slf4j.Slf4jDebugOutputStream;
import org.zeroturnaround.exec.stream.slf4j.Slf4jInfoOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProcessExecutor.class);
    public static final Integer[] DEFAULT_EXIT_VALUES = null;
    private static final Integer NORMAL_EXIT_VALUE = 0;
    public static final boolean DEFAULT_REDIRECT_ERROR_STREAM = true;
    private final ProcessBuilder builder = new ProcessBuilder(new String[0]);
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private Set<Integer> allowedExitValues;
    private Long timeout;
    private TimeUnit timeoutUnit;
    private ProcessStopper stopper;
    private ExecuteStreamHandler streams;
    private boolean readOutput;
    private final CompositeProcessListener listeners = new CompositeProcessListener();
    private MessageLogger messageLogger = MessageLoggers.DEBUG;

    public ProcessExecutor() {
        this.exitValues(DEFAULT_EXIT_VALUES);
        this.stopper(DestroyProcessStopper.INSTANCE);
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
    }

    public ProcessExecutor(List<String> command) {
        this.exitValues(DEFAULT_EXIT_VALUES);
        this.stopper(DestroyProcessStopper.INSTANCE);
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(command);
    }

    public ProcessExecutor(String ... command) {
        this.exitValues(DEFAULT_EXIT_VALUES);
        this.stopper(DestroyProcessStopper.INSTANCE);
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(command);
    }

    public ProcessExecutor command(List<String> command) {
        this.builder.command(command);
        return this;
    }

    public ProcessExecutor command(String ... command) {
        this.builder.command(command);
        return this;
    }

    public ProcessExecutor commandSplit(String commandWithArgs) {
        this.builder.command(commandWithArgs.split("\\s+"));
        return this;
    }

    public ProcessExecutor directory(File directory) {
        this.builder.directory(directory);
        return this;
    }

    public ProcessExecutor environment(Map<String, String> env) {
        this.environment.putAll(env);
        return this;
    }

    public ProcessExecutor environment(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public ProcessExecutor redirectErrorStream(boolean redirectErrorStream) {
        this.builder.redirectErrorStream(redirectErrorStream);
        return this;
    }

    public ProcessExecutor exitValueAny() {
        return this.exitValues((Integer[])null);
    }

    public ProcessExecutor exitValueNormal() {
        return this.exitValues(NORMAL_EXIT_VALUE);
    }

    public ProcessExecutor exitValue(Integer exitValue) {
        Integer[] integerArray;
        if (exitValue == null) {
            integerArray = null;
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = exitValue;
        }
        return this.exitValues(integerArray);
    }

    public ProcessExecutor exitValues(Integer ... exitValues) {
        this.allowedExitValues = exitValues == null ? null : new HashSet<Integer>(Arrays.asList(exitValues));
        return this;
    }

    public ProcessExecutor exitValues(int[] exitValues) {
        if (exitValues == null) {
            return this.exitValueAny();
        }
        Integer[] array = new Integer[exitValues.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = exitValues[i];
        }
        return this.exitValues(array);
    }

    public ProcessExecutor timeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    public ProcessExecutor stopper(ProcessStopper stopper) {
        if (stopper == null) {
            stopper = NopProcessStopper.INSTANCE;
        }
        this.stopper = stopper;
        return this;
    }

    public ExecuteStreamHandler streams() {
        return this.streams;
    }

    public ProcessExecutor streams(ExecuteStreamHandler streams) {
        this.validateStreams(streams, this.readOutput);
        this.streams = streams;
        return this;
    }

    public ProcessExecutor redirectInput(InputStream input) {
        PumpStreamHandler pumps = this.pumps();
        return this.streams(new PumpStreamHandler(pumps == null ? null : pumps.getOut(), pumps == null ? null : pumps.getErr(), input));
    }

    public ProcessExecutor redirectOutput(OutputStream output) {
        PumpStreamHandler pumps;
        if (output == null) {
            output = NullOutputStream.NULL_OUTPUT_STREAM;
        }
        return this.streams(new PumpStreamHandler(output, (pumps = this.pumps()) == null ? null : pumps.getErr(), pumps == null ? null : pumps.getInput()));
    }

    public ProcessExecutor redirectError(OutputStream output) {
        PumpStreamHandler pumps;
        if (output == null) {
            output = NullOutputStream.NULL_OUTPUT_STREAM;
        }
        this.streams(new PumpStreamHandler((pumps = this.pumps()) == null ? null : pumps.getOut(), output, pumps == null ? null : pumps.getInput()));
        this.redirectErrorStream(false);
        return this;
    }

    public ProcessExecutor redirectOutputAlsoTo(OutputStream output) {
        return this.streams(ProcessExecutor.redirectOutputAlsoTo(this.pumps(), output));
    }

    public ProcessExecutor redirectErrorAlsoTo(OutputStream output) {
        this.streams(ProcessExecutor.redirectErrorAlsoTo(this.pumps(), output));
        this.redirectErrorStream(false);
        return this;
    }

    public PumpStreamHandler pumps() {
        if (this.streams == null) {
            return null;
        }
        if (!(this.streams instanceof PumpStreamHandler)) {
            throw new IllegalStateException("Only PumpStreamHandler is supported.");
        }
        return (PumpStreamHandler)this.streams;
    }

    private static PumpStreamHandler redirectOutputAlsoTo(PumpStreamHandler pumps, OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException("OutputStream must be provided.");
        }
        OutputStream current = pumps.getOut();
        if (current != null && !(current instanceof NullOutputStream)) {
            output = new TeeOutputStream(current, output);
        }
        return new PumpStreamHandler(output, pumps.getErr(), pumps.getInput());
    }

    private static PumpStreamHandler redirectErrorAlsoTo(PumpStreamHandler pumps, OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException("OutputStream must be provided.");
        }
        OutputStream current = pumps.getErr();
        if (current != null && !(current instanceof NullOutputStream)) {
            output = new TeeOutputStream(current, output);
        }
        return new PumpStreamHandler(pumps.getOut(), output, pumps.getInput());
    }

    public ProcessExecutor readOutput(boolean readOutput) {
        this.validateStreams(this.streams, readOutput);
        this.readOutput = readOutput;
        return this;
    }

    private void validateStreams(ExecuteStreamHandler streams, boolean readOutput) {
        if (readOutput && !(streams instanceof PumpStreamHandler)) {
            throw new IllegalStateException("Only PumpStreamHandler is supported if readOutput is true.");
        }
    }

    public ProcessExecutor info(Logger log) {
        return this.redirectOutput(new Slf4jInfoOutputStream(log));
    }

    public ProcessExecutor debug(Logger log) {
        return this.redirectOutput(new Slf4jDebugOutputStream(log));
    }

    public ProcessExecutor info(String name) {
        return this.info(this.getCallerLogger(name));
    }

    public ProcessExecutor debug(String name) {
        return this.debug(this.getCallerLogger(name));
    }

    public ProcessExecutor info() {
        return this.info(this.getCallerLogger(null));
    }

    public ProcessExecutor debug() {
        return this.debug(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectOutputAsInfo(Logger log) {
        return this.redirectOutput(new Slf4jInfoOutputStream(log));
    }

    public ProcessExecutor redirectOutputAsDebug(Logger log) {
        return this.redirectOutput(new Slf4jDebugOutputStream(log));
    }

    public ProcessExecutor redirectOutputAsInfo(String name) {
        return this.redirectOutputAsInfo(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectOutputAsDebug(String name) {
        return this.redirectOutputAsDebug(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectOutputAsInfo() {
        return this.redirectOutputAsInfo(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectOutputAsDebug() {
        return this.redirectOutputAsDebug(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectErrorAsInfo(Logger log) {
        return this.redirectError(new Slf4jInfoOutputStream(log));
    }

    public ProcessExecutor redirectErrorAsDebug(Logger log) {
        return this.redirectError(new Slf4jDebugOutputStream(log));
    }

    public ProcessExecutor redirectErrorAsInfo(String name) {
        return this.redirectErrorAsInfo(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectErrorAsDebug(String name) {
        return this.redirectErrorAsDebug(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectErrorAsInfo() {
        return this.redirectErrorAsInfo(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectErrorAsDebug() {
        return this.redirectErrorAsDebug(this.getCallerLogger(null));
    }

    private Logger getCallerLogger(String name) {
        return LoggerFactory.getLogger((String)CallerLoggerUtil.getName(name, 2));
    }

    public ProcessExecutor addDestroyer(ProcessDestroyer destroyer) {
        return this.addListener(new DestroyerListenerAdapter(destroyer));
    }

    public ProcessExecutor destroyer(ProcessDestroyer destroyer) {
        this.removeListeners(DestroyerListenerAdapter.class);
        if (destroyer != null) {
            this.addListener(new DestroyerListenerAdapter(destroyer));
        }
        return this;
    }

    public ProcessExecutor destroyOnExit() {
        return this.destroyer(ShutdownHookProcessDestroyer.INSTANCE);
    }

    public ProcessExecutor listener(ProcessListener listener) {
        this.clearListeners();
        if (listener != null) {
            this.addListener(listener);
        }
        return this;
    }

    public ProcessExecutor addListener(ProcessListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public ProcessExecutor removeListener(ProcessListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public ProcessExecutor removeListeners(Class<? extends ProcessListener> listenerType) {
        this.listeners.removeAll(listenerType);
        return this;
    }

    public ProcessExecutor clearListeners() {
        this.listeners.clear();
        return this;
    }

    public ProcessExecutor setMessageLogger(MessageLogger messageLogger) {
        this.messageLogger = messageLogger;
        return this;
    }

    public ProcessResult execute() throws IOException, InterruptedException, TimeoutException, InvalidExitValueException {
        return this.waitFor(this.startInternal());
    }

    public ProcessResult executeNoTimeout() throws IOException, InterruptedException, InvalidExitValueException {
        return this.startInternal().call();
    }

    public StartedProcess start() throws IOException {
        WaitForProcess task = this.startInternal();
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        Future<ProcessResult> future = service.submit(task);
        service.shutdown();
        return new StartedProcess(task.getProcess(), future);
    }

    private WaitForProcess startInternal() throws IOException {
        Process process;
        this.listeners.beforeStart(this);
        if (this.builder.command().isEmpty()) {
            throw new IllegalStateException("Command has not been set.");
        }
        this.validateStreams(this.streams, this.readOutput);
        this.applyEnvironment();
        this.messageLogger.message(log, this.getExecutingLogMessage(), new Object[0]);
        try {
            process = this.builder.start();
        }
        catch (IOException e) {
            log.error("Could not start process:", (Throwable)e);
            throw e;
        }
        this.messageLogger.message(log, "Started {}", process);
        ProcessAttributes attributes = new ProcessAttributes(new ArrayList<String>(this.builder.command()), this.builder.directory(), new LinkedHashMap<String, String>(this.environment), (Set<Integer>)(this.allowedExitValues == null ? null : new HashSet<Integer>(this.allowedExitValues)));
        if (this.readOutput) {
            PumpStreamHandler pumps = (PumpStreamHandler)this.streams;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            return this.startInternal(process, attributes, ProcessExecutor.redirectOutputAlsoTo(pumps, out), out);
        }
        return this.startInternal(process, attributes, this.streams, null);
    }

    private String getExecutingLogMessage() {
        String result = "Executing " + this.builder.command();
        if (this.builder.directory() != null) {
            result = result + " in " + this.builder.directory();
        }
        if (!this.environment.isEmpty()) {
            result = result + " with environment " + this.environment;
        }
        result = result + ".";
        return result;
    }

    private WaitForProcess startInternal(Process process, ProcessAttributes attributes, ExecuteStreamHandler streams, ByteArrayOutputStream out) throws IOException {
        if (streams != null) {
            try {
                streams.setProcessInputStream(process.getOutputStream());
                streams.setProcessOutputStream(process.getInputStream());
                if (!this.builder.redirectErrorStream()) {
                    streams.setProcessErrorStream(process.getErrorStream());
                }
            }
            catch (IOException e) {
                process.destroy();
                throw e;
            }
            streams.start();
        }
        WaitForProcess result = new WaitForProcess(process, attributes, this.stopper, streams, out, this.listeners.clone(), this.messageLogger);
        this.listeners.afterStart(process, this);
        return result;
    }

    private ProcessResult waitFor(WaitForProcess task) throws IOException, InterruptedException, TimeoutException {
        ProcessResult result;
        if (this.timeout == null) {
            result = task.call();
        } else {
            final String name = "WaitForProcess-" + task.getProcess().toString();
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, name);
                    t.setDaemon(true);
                    return t;
                }
            });
            try {
                result = service.submit(task).get(this.timeout, this.timeoutUnit);
            }
            catch (ExecutionException e) {
                Throwable c = e.getCause();
                if (c instanceof IOException) {
                    throw (IOException)c;
                }
                if (c instanceof InterruptedException) {
                    throw (InterruptedException)c;
                }
                if (c instanceof InvalidExitValueException) {
                    throw (InvalidExitValueException)c;
                }
                throw new IllegalStateException("Error occured while waiting for process to finish:", c);
            }
            catch (TimeoutException e) {
                this.messageLogger.message(log, "{} is running too long", task);
                throw e;
            }
            finally {
                service.shutdownNow();
            }
        }
        return result;
    }

    private void applyEnvironment() {
        if (this.environment.isEmpty()) {
            return;
        }
        Map<String, String> env = this.builder.environment();
        for (Map.Entry<String, String> e : this.environment.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (value == null) {
                env.remove(key);
                continue;
            }
            env.put(key, value);
        }
    }
}

