/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.typeresolution.TypeHelper;

public class InefficientStringBuffering
extends AbstractRule {
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceType;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatementExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLiteral;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlockStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAllocationExpression;
    private static final /* synthetic */ Class class$java$lang$StringBuffer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTArgumentList;
    private static final /* synthetic */ Class class$java$lang$StringBuilder;

    public Object visit(ASTAdditiveExpression node, Object data) {
        ASTName name;
        ASTBlockStatement bs;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTBlockStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTBlockStatement = new ASTBlockStatement[0].getClass().getComponentType();
        }
        if ((bs = (ASTBlockStatement)node.getFirstParentOfType(clazz)) == null) {
            return data;
        }
        int immediateLiterals = 0;
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTLiteral;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTLiteral = new ASTLiteral[0].getClass().getComponentType();
        }
        List nodes = node.findChildrenOfType(clazz2);
        Iterator i$ = nodes.iterator();
        while (i$.hasNext()) {
            ASTLiteral literal = (ASTLiteral)i$.next();
            if (literal.jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTAdditiveExpression) {
                ++immediateLiterals;
            }
            try {
                Integer.parseInt(literal.getImage());
                return data;
            }
            catch (NumberFormatException nfe) {
            }
        }
        if (immediateLiterals > 1) {
            return data;
        }
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTName;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
        }
        List nameNodes = node.findChildrenOfType(clazz3);
        Iterator i$2 = nameNodes.iterator();
        while (i$2.hasNext()) {
            VariableNameDeclaration vnd;
            name = (ASTName)i$2.next();
            if (!(name.getNameDeclaration() instanceof VariableNameDeclaration) || !(vnd = (VariableNameDeclaration)name.getNameDeclaration()).getAccessNodeParent().isFinal() || !vnd.getAccessNodeParent().isStatic()) continue;
            return data;
        }
        if (bs.isAllocation()) {
            Iterator iterator = nameNodes.iterator();
            while (iterator.hasNext() && (name = (ASTName)iterator.next()).getImage().endsWith("length")) {
                if (iterator.hasNext()) continue;
                return data;
            }
            if (this.isAllocatedStringBuffer(node)) {
                this.addViolation(data, node);
            }
        } else if (InefficientStringBuffering.isInStringBufferOperation(node, 6, "append")) {
            this.addViolation(data, node);
        }
        return data;
    }

    protected static boolean isInStringBufferOperation(SimpleNode node, int length, String methodName) {
        ASTArgumentList argList;
        ASTName n;
        ASTStatementExpression s;
        if (!InefficientStringBuffering.xParentIsStatementExpression(node, length)) {
            return false;
        }
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTStatementExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTStatementExpression = new ASTStatementExpression[0].getClass().getComponentType();
        }
        if ((s = (ASTStatementExpression)node.getFirstParentOfType(clazz)) == null) {
            return false;
        }
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTName;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
        }
        if ((n = (ASTName)s.getFirstChildOfType(clazz2)) == null || n.getImage().indexOf(methodName) == -1 || !(n.getNameDeclaration() instanceof VariableNameDeclaration)) {
            return false;
        }
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTArgumentList;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTArgumentList = new ASTArgumentList[0].getClass().getComponentType();
        }
        if ((argList = (ASTArgumentList)s.getFirstChildOfType(clazz3)) == null || argList.jjtGetNumChildren() > 1) {
            return false;
        }
        VariableNameDeclaration variableNameDeclaration = (VariableNameDeclaration)n.getNameDeclaration();
        Class<?> clazz4 = class$java$lang$StringBuffer;
        if (clazz4 == null) {
            clazz4 = class$java$lang$StringBuffer = new StringBuffer[0].getClass().getComponentType();
        }
        return TypeHelper.isA(variableNameDeclaration, (Class)clazz4);
    }

    private static boolean xParentIsStatementExpression(SimpleNode node, int length) {
        Node curr = node;
        for (int i = 0; i < length; ++i) {
            if (node.jjtGetParent() == null) {
                return false;
            }
            curr = curr.jjtGetParent();
        }
        return curr instanceof ASTStatementExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAllocatedStringBuffer(ASTAdditiveExpression node) {
        ASTClassOrInterfaceType an;
        ASTAllocationExpression ao;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAllocationExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAllocationExpression = new ASTAllocationExpression[0].getClass().getComponentType();
        }
        if ((ao = (ASTAllocationExpression)node.getFirstParentOfType(clazz)) == null) {
            return false;
        }
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceType;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceType = new ASTClassOrInterfaceType[0].getClass().getComponentType();
        }
        if ((an = (ASTClassOrInterfaceType)ao.getFirstChildOfType(clazz2)) == null) return false;
        Class<?> clazz3 = class$java$lang$StringBuffer;
        if (clazz3 == null) {
            clazz3 = class$java$lang$StringBuffer = new StringBuffer[0].getClass().getComponentType();
        }
        if (TypeHelper.isA(an, (Class)clazz3)) return true;
        Class<?> clazz4 = class$java$lang$StringBuilder;
        if (clazz4 == null) {
            clazz4 = class$java$lang$StringBuilder = new StringBuffer[0].getClass().getComponentType();
        }
        if (!TypeHelper.isA(an, (Class)clazz4)) return false;
        return true;
    }
}

