/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisException;

public abstract class BinaryJedisPubSub {
    private int subscribedChannels = 0;
    private Connection client;

    public void onMessage(byte[] channel, byte[] message) {
    }

    public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
    }

    public void onSubscribe(byte[] channel, int subscribedChannels) {
    }

    public void onUnsubscribe(byte[] channel, int subscribedChannels) {
    }

    public void onPUnsubscribe(byte[] pattern, int subscribedChannels) {
    }

    public void onPSubscribe(byte[] pattern, int subscribedChannels) {
    }

    public void onPong(byte[] pattern) {
    }

    public void unsubscribe() {
        this.client.sendCommand(Protocol.Command.UNSUBSCRIBE);
        this.client.flush();
    }

    public void unsubscribe(byte[] ... channels) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE, channels);
        this.client.flush();
    }

    public void subscribe(byte[] ... channels) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.SUBSCRIBE, channels);
        this.client.flush();
    }

    public void psubscribe(byte[] ... patterns) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PSUBSCRIBE, patterns);
        this.client.flush();
    }

    public void punsubscribe() {
        this.client.sendCommand(Protocol.Command.PUNSUBSCRIBE);
        this.client.flush();
    }

    public void punsubscribe(byte[] ... patterns) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE, patterns);
        this.client.flush();
    }

    public void ping() {
        this.client.sendCommand(Protocol.Command.PING);
        this.client.flush();
    }

    public void ping(byte[] argument) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PING, new byte[][]{argument});
        this.client.flush();
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Connection client, byte[] ... patterns) {
        this.client = client;
        this.client.setTimeoutInfinite();
        try {
            this.psubscribe(patterns);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    public void proceed(Connection client, byte[] ... channels) {
        this.client = client;
        this.client.setTimeoutInfinite();
        try {
            this.subscribe(channels);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    private void process() {
        do {
            byte[] bpattern;
            byte[] bchannel;
            List<Object> reply;
            Object firstObj;
            if (!((firstObj = (reply = this.client.getUnflushedObjectMultiBulkReply()).get(0)) instanceof byte[])) {
                throw new JedisException("Unknown message type: " + firstObj);
            }
            byte[] resp = (byte[])firstObj;
            if (Arrays.equals(Protocol.ResponseKeyword.SUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                this.onSubscribe(bchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.UNSUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                this.onUnsubscribe(bchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.MESSAGE.getRaw(), resp)) {
                bchannel = (byte[])reply.get(1);
                byte[] bmesg = (byte[])reply.get(2);
                this.onMessage(bchannel, bmesg);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PMESSAGE.getRaw(), resp)) {
                bpattern = (byte[])reply.get(1);
                byte[] bchannel2 = (byte[])reply.get(2);
                byte[] bmesg = (byte[])reply.get(3);
                this.onPMessage(bpattern, bchannel2, bmesg);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PSUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                this.onPSubscribe(bpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PUNSUBSCRIBE.getRaw(), resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                this.onPUnsubscribe(bpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PONG.getRaw(), resp)) {
                bpattern = (byte[])reply.get(1);
                this.onPong(bpattern);
                continue;
            }
            throw new JedisException("Unknown message type: " + firstObj);
        } while (this.isSubscribed());
    }

    public int getSubscribedChannels() {
        return this.subscribedChannels;
    }
}

