/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import redis.clients.jedis.Connection;
import redis.clients.jedis.TransactionBase;
import redis.clients.jedis.exceptions.JedisException;

public class ReliableTransaction
extends TransactionBase {
    private static final String QUEUED_STR = "QUEUED";

    public ReliableTransaction(Connection connection) {
        super(connection);
    }

    public ReliableTransaction(Connection connection, boolean doMulti) {
        super(connection, doMulti);
    }

    public ReliableTransaction(Connection connection, boolean doMulti, boolean closeConnection) {
        super(connection, doMulti, closeConnection);
    }

    @Override
    protected final void processMultiResponse() {
        String status = this.connection.getStatusCodeReply();
        if (!"OK".equals(status)) {
            throw new JedisException("MULTI command failed. Received response: " + status);
        }
    }

    @Override
    protected final void processAppendStatus() {
        String status = this.connection.getStatusCodeReply();
        if (!QUEUED_STR.equals(status)) {
            throw new JedisException(status);
        }
    }

    @Override
    protected final void processPipelinedResponses() {
    }

    @Override
    public final List<Object> exec() {
        return super.exec();
    }

    @Override
    public final String discard() {
        String status = super.discard();
        if (!"OK".equals(status)) {
            throw new JedisException("DISCARD command failed. Received response: " + status);
        }
        return status;
    }
}

