/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.aggr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.aggr.Group;
import redis.clients.jedis.search.aggr.Limit;
import redis.clients.jedis.search.aggr.Reducer;
import redis.clients.jedis.search.aggr.SortedField;
import redis.clients.jedis.util.SafeEncoder;

public class AggregationBuilder {
    private final List<String> args = new ArrayList<String>();
    private boolean isWithCursor = false;

    public AggregationBuilder(String query) {
        this.args.add(query);
    }

    public AggregationBuilder() {
        this("*");
    }

    public AggregationBuilder load(String ... fields) {
        return this.load(FieldName.convert(fields));
    }

    public AggregationBuilder load(FieldName ... fields) {
        this.args.add("LOAD");
        int loadCountIndex = this.args.size();
        this.args.add(null);
        int loadCount = 0;
        for (FieldName fn : fields) {
            loadCount += fn.addCommandEncodedArguments(this.args);
        }
        this.args.set(loadCountIndex, Integer.toString(loadCount));
        return this;
    }

    public AggregationBuilder loadAll() {
        this.args.add("LOAD");
        this.args.add("*");
        return this;
    }

    public AggregationBuilder limit(int offset, int count) {
        Limit limit = new Limit(offset, count);
        limit.addArgs(this.args);
        return this;
    }

    public AggregationBuilder limit(int count) {
        return this.limit(0, count);
    }

    public AggregationBuilder sortBy(SortedField ... fields) {
        this.args.add("SORTBY");
        this.args.add(Integer.toString(fields.length * 2));
        for (SortedField field : fields) {
            this.args.add(field.getField());
            this.args.add(field.getOrder());
        }
        return this;
    }

    public AggregationBuilder sortBy(int max, SortedField ... fields) {
        this.sortBy(fields);
        if (max > 0) {
            this.args.add("MAX");
            this.args.add(Integer.toString(max));
        }
        return this;
    }

    public AggregationBuilder sortByAsc(String field) {
        return this.sortBy(SortedField.asc(field));
    }

    public AggregationBuilder sortByDesc(String field) {
        return this.sortBy(SortedField.desc(field));
    }

    public AggregationBuilder apply(String projection, String alias) {
        this.args.add("APPLY");
        this.args.add(projection);
        this.args.add("AS");
        this.args.add(alias);
        return this;
    }

    public AggregationBuilder groupBy(Collection<String> fields, Collection<Reducer> reducers) {
        String[] fieldsArr = new String[fields.size()];
        Group g = new Group(fields.toArray(fieldsArr));
        for (Reducer r : reducers) {
            g.reduce(r);
        }
        this.groupBy(g);
        return this;
    }

    public AggregationBuilder groupBy(String field, Reducer ... reducers) {
        return this.groupBy(Collections.singletonList(field), Arrays.asList(reducers));
    }

    public AggregationBuilder groupBy(Group group) {
        this.args.add("GROUPBY");
        group.addArgs(this.args);
        return this;
    }

    public AggregationBuilder filter(String expression) {
        this.args.add("FILTER");
        this.args.add(expression);
        return this;
    }

    public AggregationBuilder cursor(int count, long maxIdle) {
        this.isWithCursor = true;
        if (count > 0) {
            this.args.add("WITHCURSOR");
            this.args.add("COUNT");
            this.args.add(Integer.toString(count));
            if (maxIdle < Long.MAX_VALUE && maxIdle >= 0L) {
                this.args.add("MAXIDLE");
                this.args.add(Long.toString(maxIdle));
            }
        }
        return this;
    }

    public AggregationBuilder verbatim() {
        this.args.add("VERBATIM");
        return this;
    }

    public AggregationBuilder timeout(long timeout) {
        if (timeout >= 0L) {
            this.args.add("TIMEOUT");
            this.args.add(Long.toString(timeout));
        }
        return this;
    }

    public AggregationBuilder params(Map<String, Object> params) {
        if (params.size() >= 1) {
            this.args.add("PARAMS");
            this.args.add(Integer.toString(params.size() * 2));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                this.args.add(entry.getKey());
                this.args.add(String.valueOf(entry.getValue()));
            }
        }
        return this;
    }

    public AggregationBuilder dialect(int dialect) {
        this.args.add("DIALECT");
        this.args.add(Integer.toString(dialect));
        return this;
    }

    @Deprecated
    public List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    @Deprecated
    public void serializeRedisArgs(List<byte[]> redisArgs) {
        for (String s : this.getArgs()) {
            redisArgs.add(SafeEncoder.encode(s));
        }
    }

    @Deprecated
    public String getArgsString() {
        StringJoiner sj = new StringJoiner(" ");
        for (String s : this.getArgs()) {
            sj.add(s);
        }
        return sj.toString();
    }

    public boolean isWithCursor() {
        return this.isWithCursor;
    }
}

