/*
 * Decompiled with CFR 0.152.
 */
package site.howaric.encryption;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import site.howaric.encryption.exception.RSACryptogramException;

public class RSAUtil {
    private static final int KEY_SIZE = 512;
    private static final String ALGORITHM = "RSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    public static Map<String, Object> getKeyPairMap() {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RSACryptogramException("Get key pair failed", e);
        }
        keyPairGenerator.initialize(512);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String getPrivateKey(Map<String, Object> keyPairMap) {
        Key key = (Key)keyPairMap.get(PRIVATE_KEY);
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyPairMap) {
        Key key = (Key)keyPairMap.get(PUBLIC_KEY);
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static String encryptByPrivateKey(String data, String privateKey) {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PrivateKey pKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, pKey);
            byte[] doFinal = cipher.doFinal(data.getBytes());
            return Base64.getEncoder().encodeToString(doFinal);
        }
        catch (Exception e) {
            throw new RSACryptogramException("Encrypt by privateKey failed", e);
        }
    }

    public static String encryptByPublicKey(String data, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey));
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, pubKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes()));
        }
        catch (Exception e) {
            throw new RSACryptogramException("Encrypt by publicKey failed", e);
        }
    }

    public static String decryptByPrivateKey(String data, String privateKey) {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, priKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data)));
        }
        catch (Exception e) {
            throw new RSACryptogramException("Decrypt by privateKey failed", e);
        }
    }

    public static String decryptByPublicKey(String data, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey));
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, pubKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data)));
        }
        catch (Exception e) {
            throw new RSACryptogramException("Decrypt by publicKey failed", e);
        }
    }
}

