/*
 * Decompiled with CFR 0.152.
 */
package site.howaric.encryption;

import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import site.howaric.encryption.EncryptedField;
import site.howaric.encryption.RSAUtil;
import site.howaric.encryption.SignUtil;
import site.howaric.encryption.Signed;
import site.howaric.encryption.SignedField;
import site.howaric.encryption.exception.SignatureVerificationFailedException;
import site.howaric.reflection.FieldUtil;

public abstract class SignedData
implements Signed {
    private static final Logger LOG = LoggerFactory.getLogger(SignedData.class);
    @SignedField
    @ApiModelProperty(value="\u968f\u673a\u5b57\u7b26\u4e32", required=true)
    protected String nonce;
    @SignedField
    @ApiModelProperty(value="\u65f6\u95f4\u6233", required=true)
    protected String timestamp;
    @ApiModelProperty(value="\u7b7e\u540d", required=true)
    protected String sign;
    private boolean isVerify = false;

    @Override
    public void sign(String privateKey) {
        this.sign = this.doSign(privateKey);
    }

    private String doSign(String privateKey) {
        if (this.sign == null) {
            this.prepare();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        List<Field> allDeclaredFields = FieldUtil.getAllDeclaredFields(this.getClass());
        for (Field field : allDeclaredFields) {
            if (!this.isVerify && field.getDeclaredAnnotation(EncryptedField.class) != null) {
                this.encryptField(field, privateKey);
            }
            if (field.getDeclaredAnnotation(SignedField.class) == null) continue;
            this.fillSignField(field, params);
        }
        LinkedList keyList = new LinkedList(params.keySet());
        Collections.sort(keyList);
        StringBuilder signatureLink = new StringBuilder();
        for (int i = 0; i < keyList.size(); ++i) {
            signatureLink.append((String)keyList.get(i));
            signatureLink.append("=");
            signatureLink.append((String)params.get(keyList.get(i)));
            signatureLink.append("&");
        }
        LOG.debug("SignLink: " + signatureLink.toString() + "key=***");
        signatureLink.append("key=");
        signatureLink.append(privateKey);
        return SignUtil.SHA256(signatureLink.toString(), privateKey).toUpperCase();
    }

    private void prepare() {
        this.nonce = String.valueOf(Math.random());
        this.timestamp = String.valueOf(System.currentTimeMillis());
        this.sign = "";
    }

    private void encryptField(Field field, String privateKey) {
        Object value = FieldUtil.getFieldValue(field, this);
        if (!this.isObjectEmpty(value)) {
            FieldUtil.setFieldValue(field, this, RSAUtil.encryptByPrivateKey(String.valueOf(value), privateKey));
        }
    }

    private void fillSignField(Field field, Map<String, String> params) {
        Object value = FieldUtil.getFieldValue(field, this);
        if (!this.isObjectEmpty(value)) {
            params.put(field.getName(), String.valueOf(value));
        }
    }

    private boolean isObjectEmpty(Object object) {
        return object == null || "".equals(object.toString());
    }

    @Override
    public void verify(String privateKey) {
        if (this.sign == null || "".equals(this.sign)) {
            throw new SignatureVerificationFailedException("Signature not found");
        }
        this.isVerify = true;
        if (!this.doSign(privateKey).equals(this.sign)) {
            throw new SignatureVerificationFailedException("Illegal signature");
        }
    }

    @Override
    public void verify(String privateKey, int expirationTime) {
        if (System.currentTimeMillis() - Long.valueOf(this.timestamp) > (long)(expirationTime * 1000)) {
            throw new SignatureVerificationFailedException("Signature expired");
        }
        this.verify(privateKey);
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getSign() {
        return this.sign;
    }

    public String toString() {
        List<Field> allDeclaredFields = FieldUtil.getAllDeclaredFields(this.getClass());
        StringBuilder sb = new StringBuilder("SignedData {");
        for (Field field : allDeclaredFields) {
            if (field.getName().equals("isVerify") || field.getName().equals("LOG")) continue;
            sb.append(field.getName().concat("=")).append(FieldUtil.getFieldValue(field, this)).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("}");
        return sb.toString();
    }
}

