/*
 * Decompiled with CFR 0.152.
 */
package site.howaric.poll;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import site.howaric.poll.PollException;
import site.howaric.poll.PollJob;

public class PollExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PollExecutor.class);

    public static void execute(PollJob pollJob, Integer interval, Integer duration, TimeUnit unit) {
        if (interval <= 0 || duration <= 0) {
            throw new PollException("Illegal interval or duration time");
        }
        int index = 0;
        long intervalSeconds = unit.toSeconds(interval.longValue());
        long intervalMillis = unit.toMillis(interval.longValue());
        long durationSeconds = unit.toSeconds(duration.longValue());
        while ((long)index * intervalSeconds < durationSeconds) {
            if (pollJob.poll().booleanValue()) {
                return;
            }
            LOG.info("PollJob Progress [index:{} interval:{} duration:{}] TimeUnit:{}", new Object[]{index + 1, interval, duration, unit.name()});
            PollExecutor.sleep(intervalMillis);
            ++index;
        }
        throw new PollException("PollJob Timeout");
    }

    public static void execute(PollJob pollJob, Integer interval, Integer duration) {
        PollExecutor.execute(pollJob, interval, duration, TimeUnit.SECONDS);
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.error("Sleep in PollJob Interrupted", (Throwable)e);
        }
    }
}

