/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.response;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.utils.CommonUtils;

public class InstanceDetailVO {
    private String expectedTriggerTime;
    private String actualTriggerTime;
    private String finishedTime;
    private Integer status;
    private String result;
    private String taskTrackerAddress;
    private String jobParams;
    private String instanceParams;
    private TaskDetail taskDetail;
    private List<SubInstanceDetail> subInstanceDetails;
    private Long runningTimes;

    public static InstanceDetailVO from(InstanceDetail origin) {
        InstanceDetailVO vo = new InstanceDetailVO();
        BeanUtils.copyProperties((Object)origin, (Object)vo);
        vo.setFinishedTime(CommonUtils.formatTime((Long)origin.getFinishedTime()));
        vo.setActualTriggerTime(CommonUtils.formatTime((Long)origin.getActualTriggerTime()));
        vo.setExpectedTriggerTime(CommonUtils.formatTime((Long)origin.getExpectedTriggerTime()));
        if (origin.getTaskDetail() != null) {
            TaskDetail voDetail = new TaskDetail();
            BeanUtils.copyProperties((Object)origin.getTaskDetail(), (Object)voDetail);
            vo.setTaskDetail(voDetail);
        }
        if (!CollectionUtils.isEmpty((Collection)origin.getSubInstanceDetails())) {
            vo.subInstanceDetails = Lists.newLinkedList();
            origin.getSubInstanceDetails().forEach(subDetail -> {
                SubInstanceDetail voSubDetail = new SubInstanceDetail();
                BeanUtils.copyProperties((Object)subDetail, (Object)voSubDetail);
                voSubDetail.setStartTime(CommonUtils.formatTime((Long)subDetail.getStartTime()));
                voSubDetail.setFinishedTime(CommonUtils.formatTime((Long)subDetail.getFinishedTime()));
                vo.subInstanceDetails.add(voSubDetail);
            });
        }
        return vo;
    }

    public String getExpectedTriggerTime() {
        return this.expectedTriggerTime;
    }

    public String getActualTriggerTime() {
        return this.actualTriggerTime;
    }

    public String getFinishedTime() {
        return this.finishedTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public String getTaskTrackerAddress() {
        return this.taskTrackerAddress;
    }

    public String getJobParams() {
        return this.jobParams;
    }

    public String getInstanceParams() {
        return this.instanceParams;
    }

    public TaskDetail getTaskDetail() {
        return this.taskDetail;
    }

    public List<SubInstanceDetail> getSubInstanceDetails() {
        return this.subInstanceDetails;
    }

    public Long getRunningTimes() {
        return this.runningTimes;
    }

    public void setExpectedTriggerTime(String expectedTriggerTime) {
        this.expectedTriggerTime = expectedTriggerTime;
    }

    public void setActualTriggerTime(String actualTriggerTime) {
        this.actualTriggerTime = actualTriggerTime;
    }

    public void setFinishedTime(String finishedTime) {
        this.finishedTime = finishedTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setTaskTrackerAddress(String taskTrackerAddress) {
        this.taskTrackerAddress = taskTrackerAddress;
    }

    public void setJobParams(String jobParams) {
        this.jobParams = jobParams;
    }

    public void setInstanceParams(String instanceParams) {
        this.instanceParams = instanceParams;
    }

    public void setTaskDetail(TaskDetail taskDetail) {
        this.taskDetail = taskDetail;
    }

    public void setSubInstanceDetails(List<SubInstanceDetail> subInstanceDetails) {
        this.subInstanceDetails = subInstanceDetails;
    }

    public void setRunningTimes(Long runningTimes) {
        this.runningTimes = runningTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceDetailVO)) {
            return false;
        }
        InstanceDetailVO other = (InstanceDetailVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$expectedTriggerTime = this.getExpectedTriggerTime();
        String other$expectedTriggerTime = other.getExpectedTriggerTime();
        if (this$expectedTriggerTime == null ? other$expectedTriggerTime != null : !this$expectedTriggerTime.equals(other$expectedTriggerTime)) {
            return false;
        }
        String this$actualTriggerTime = this.getActualTriggerTime();
        String other$actualTriggerTime = other.getActualTriggerTime();
        if (this$actualTriggerTime == null ? other$actualTriggerTime != null : !this$actualTriggerTime.equals(other$actualTriggerTime)) {
            return false;
        }
        String this$finishedTime = this.getFinishedTime();
        String other$finishedTime = other.getFinishedTime();
        if (this$finishedTime == null ? other$finishedTime != null : !this$finishedTime.equals(other$finishedTime)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$taskTrackerAddress = this.getTaskTrackerAddress();
        String other$taskTrackerAddress = other.getTaskTrackerAddress();
        if (this$taskTrackerAddress == null ? other$taskTrackerAddress != null : !this$taskTrackerAddress.equals(other$taskTrackerAddress)) {
            return false;
        }
        String this$jobParams = this.getJobParams();
        String other$jobParams = other.getJobParams();
        if (this$jobParams == null ? other$jobParams != null : !this$jobParams.equals(other$jobParams)) {
            return false;
        }
        String this$instanceParams = this.getInstanceParams();
        String other$instanceParams = other.getInstanceParams();
        if (this$instanceParams == null ? other$instanceParams != null : !this$instanceParams.equals(other$instanceParams)) {
            return false;
        }
        TaskDetail this$taskDetail = this.getTaskDetail();
        TaskDetail other$taskDetail = other.getTaskDetail();
        if (this$taskDetail == null ? other$taskDetail != null : !((Object)this$taskDetail).equals(other$taskDetail)) {
            return false;
        }
        List<SubInstanceDetail> this$subInstanceDetails = this.getSubInstanceDetails();
        List<SubInstanceDetail> other$subInstanceDetails = other.getSubInstanceDetails();
        if (this$subInstanceDetails == null ? other$subInstanceDetails != null : !((Object)this$subInstanceDetails).equals(other$subInstanceDetails)) {
            return false;
        }
        Long this$runningTimes = this.getRunningTimes();
        Long other$runningTimes = other.getRunningTimes();
        return !(this$runningTimes == null ? other$runningTimes != null : !((Object)this$runningTimes).equals(other$runningTimes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstanceDetailVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $expectedTriggerTime = this.getExpectedTriggerTime();
        result = result * 59 + ($expectedTriggerTime == null ? 43 : $expectedTriggerTime.hashCode());
        String $actualTriggerTime = this.getActualTriggerTime();
        result = result * 59 + ($actualTriggerTime == null ? 43 : $actualTriggerTime.hashCode());
        String $finishedTime = this.getFinishedTime();
        result = result * 59 + ($finishedTime == null ? 43 : $finishedTime.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $taskTrackerAddress = this.getTaskTrackerAddress();
        result = result * 59 + ($taskTrackerAddress == null ? 43 : $taskTrackerAddress.hashCode());
        String $jobParams = this.getJobParams();
        result = result * 59 + ($jobParams == null ? 43 : $jobParams.hashCode());
        String $instanceParams = this.getInstanceParams();
        result = result * 59 + ($instanceParams == null ? 43 : $instanceParams.hashCode());
        TaskDetail $taskDetail = this.getTaskDetail();
        result = result * 59 + ($taskDetail == null ? 43 : ((Object)$taskDetail).hashCode());
        List<SubInstanceDetail> $subInstanceDetails = this.getSubInstanceDetails();
        result = result * 59 + ($subInstanceDetails == null ? 43 : ((Object)$subInstanceDetails).hashCode());
        Long $runningTimes = this.getRunningTimes();
        result = result * 59 + ($runningTimes == null ? 43 : ((Object)$runningTimes).hashCode());
        return result;
    }

    public String toString() {
        return "InstanceDetailVO(expectedTriggerTime=" + this.getExpectedTriggerTime() + ", actualTriggerTime=" + this.getActualTriggerTime() + ", finishedTime=" + this.getFinishedTime() + ", status=" + this.getStatus() + ", result=" + this.getResult() + ", taskTrackerAddress=" + this.getTaskTrackerAddress() + ", jobParams=" + this.getJobParams() + ", instanceParams=" + this.getInstanceParams() + ", taskDetail=" + this.getTaskDetail() + ", subInstanceDetails=" + this.getSubInstanceDetails() + ", runningTimes=" + this.getRunningTimes() + ")";
    }

    public static class TaskDetail
    implements PowerSerializable {
        private long totalTaskNum;
        private long succeedTaskNum;
        private long failedTaskNum;

        public long getTotalTaskNum() {
            return this.totalTaskNum;
        }

        public long getSucceedTaskNum() {
            return this.succeedTaskNum;
        }

        public long getFailedTaskNum() {
            return this.failedTaskNum;
        }

        public void setTotalTaskNum(long totalTaskNum) {
            this.totalTaskNum = totalTaskNum;
        }

        public void setSucceedTaskNum(long succeedTaskNum) {
            this.succeedTaskNum = succeedTaskNum;
        }

        public void setFailedTaskNum(long failedTaskNum) {
            this.failedTaskNum = failedTaskNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskDetail)) {
                return false;
            }
            TaskDetail other = (TaskDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalTaskNum() != other.getTotalTaskNum()) {
                return false;
            }
            if (this.getSucceedTaskNum() != other.getSucceedTaskNum()) {
                return false;
            }
            return this.getFailedTaskNum() == other.getFailedTaskNum();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $totalTaskNum = this.getTotalTaskNum();
            result = result * 59 + (int)($totalTaskNum >>> 32 ^ $totalTaskNum);
            long $succeedTaskNum = this.getSucceedTaskNum();
            result = result * 59 + (int)($succeedTaskNum >>> 32 ^ $succeedTaskNum);
            long $failedTaskNum = this.getFailedTaskNum();
            result = result * 59 + (int)($failedTaskNum >>> 32 ^ $failedTaskNum);
            return result;
        }

        public String toString() {
            return "InstanceDetailVO.TaskDetail(totalTaskNum=" + this.getTotalTaskNum() + ", succeedTaskNum=" + this.getSucceedTaskNum() + ", failedTaskNum=" + this.getFailedTaskNum() + ")";
        }
    }

    public static class SubInstanceDetail
    implements PowerSerializable {
        private long subInstanceId;
        private String startTime;
        private String finishedTime;
        private String result;
        private int status;

        public long getSubInstanceId() {
            return this.subInstanceId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getFinishedTime() {
            return this.finishedTime;
        }

        public String getResult() {
            return this.result;
        }

        public int getStatus() {
            return this.status;
        }

        public void setSubInstanceId(long subInstanceId) {
            this.subInstanceId = subInstanceId;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public void setFinishedTime(String finishedTime) {
            this.finishedTime = finishedTime;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubInstanceDetail)) {
                return false;
            }
            SubInstanceDetail other = (SubInstanceDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSubInstanceId() != other.getSubInstanceId()) {
                return false;
            }
            String this$startTime = this.getStartTime();
            String other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
                return false;
            }
            String this$finishedTime = this.getFinishedTime();
            String other$finishedTime = other.getFinishedTime();
            if (this$finishedTime == null ? other$finishedTime != null : !this$finishedTime.equals(other$finishedTime)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            return this.getStatus() == other.getStatus();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubInstanceDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $subInstanceId = this.getSubInstanceId();
            result = result * 59 + (int)($subInstanceId >>> 32 ^ $subInstanceId);
            String $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
            String $finishedTime = this.getFinishedTime();
            result = result * 59 + ($finishedTime == null ? 43 : $finishedTime.hashCode());
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            result = result * 59 + this.getStatus();
            return result;
        }

        public String toString() {
            return "InstanceDetailVO.SubInstanceDetail(subInstanceId=" + this.getSubInstanceId() + ", startTime=" + this.getStartTime() + ", finishedTime=" + this.getFinishedTime() + ", result=" + this.getResult() + ", status=" + this.getStatus() + ")";
        }
    }
}

