/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.common;

import java.util.ArrayList;
import tech.spiro.addrparser.common.Point;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.common.RegionInfo;

public class RegionConverter {
    public static RegionInfo convert(RegionDTO regionDTO) {
        String[] blocks;
        RegionInfo.Builder builder = new RegionInfo.Builder();
        builder.parentCode(regionDTO.getParentCode());
        builder.code(regionDTO.getCode());
        builder.name(regionDTO.getName());
        builder.level(regionDTO.getLevel());
        String[] center = regionDTO.getCenter().split(",");
        Point centerPoint = new Point(Double.valueOf(center[0]), Double.valueOf(center[1]));
        builder.center(centerPoint);
        String polyline = regionDTO.getPolyline();
        for (String block : blocks = polyline.split("\\|")) {
            String[] points;
            ArrayList<Point> blockObj = new ArrayList<Point>();
            for (String point : points = block.split(";")) {
                String[] lonLat = point.split(",");
                Point pointObj = new Point(Double.valueOf(lonLat[0]), Double.valueOf(lonLat[1]));
                blockObj.add(pointObj);
            }
            builder.addPolyline(blockObj);
        }
        return builder.build();
    }
}

