/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.crawler;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.crawler.DataResp;
import tech.spiro.addrparser.crawler.GetRegionException;

public class RestClient {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private String key;
    private String keywords;
    private String subdistrict;
    private String extensions;
    private CloseableHttpClient httpClient = HttpClients.createDefault();

    public DataResp getDistrictResponse() throws GetRegionException {
        URI uri = null;
        try {
            uri = new URIBuilder().setScheme("http").setHost("restapi.amap.com").setPath("/v3/config/district").setParameter("key", this.getKey()).setParameter("keywords", this.getKeywords()).setParameter("subdistrict", this.getSubdistrict()).setParameter("extensions", this.getExtensions()).build();
        }
        catch (URISyntaxException e) {
            throw new GetRegionException("uri syntax error.");
        }
        HttpGet httpGet = new HttpGet(uri);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new GetRegionException("Execute get request failed, http-code=" + response.getStatusLine().getStatusCode());
            }
            String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            DataResp dataResp = (DataResp)JSON.parseObject((String)responseContent, DataResp.class);
            return dataResp;
        }
        catch (IOException e) {
            throw new GetRegionException("Execute get request exception.");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getSubdistrict() {
        return this.subdistrict;
    }

    public void setSubdistrict(String subdistrict) {
        this.subdistrict = subdistrict;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }
}

