/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.io.file;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.io.RegionDataOutput;
import tech.spiro.addrparser.io.RegionDataReport;

public abstract class BinaryFileRegionDataOutput
implements RegionDataOutput {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryFileRegionDataOutput.class);
    protected OutputStream out;
    protected String filename;
    protected long writeBytes = 0L;
    private boolean initialized = false;
    private RegionDataReport report = new RegionDataReport();

    public BinaryFileRegionDataOutput(String filename) {
        this.filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        if (this.initialized) {
            return;
        }
        BinaryFileRegionDataOutput binaryFileRegionDataOutput = this;
        synchronized (binaryFileRegionDataOutput) {
            if (this.initialized) {
                return;
            }
            this.out = new BufferedOutputStream(new FileOutputStream(this.filename));
            this.initialized = true;
        }
    }

    @Override
    public void write(RegionDTO regionDTO) throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        if (regionDTO == null) {
            throw new IllegalArgumentException("<regionDTO> cannot be null.");
        }
        byte[] serializedBytes = this.serialize(regionDTO);
        this.out.write(serializedBytes);
        this.writeBytes += (long)serializedBytes.length;
        this.report.record(regionDTO);
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        LOG.info("------------------ BinaryFile Report ----------------");
        LOG.info("Write byte size: {}.", (Object)this.writeBytes);
        LOG.info(this.report.report());
        LOG.info("-----------------------------------------------------");
        this.out.close();
    }

    protected abstract byte[] serialize(RegionDTO var1);
}

