/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.io.file;

import com.alibaba.fastjson.JSONReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.io.RegionDataInput;
import tech.spiro.addrparser.io.RegionDataReport;

public class JSONFileRegionDataInput
implements RegionDataInput {
    private static final Logger LOG = LoggerFactory.getLogger(JSONFileRegionDataInput.class);
    private Reader _reader;
    private String filename;
    private JSONReader reader;
    private RegionDataReport report = new RegionDataReport();
    private boolean initialized = false;

    public JSONFileRegionDataInput(String filename) {
        this.filename = filename;
        if (this.filename == null) {
            throw new IllegalArgumentException("<filename> cannot be null.");
        }
    }

    public JSONFileRegionDataInput(Reader _reader) {
        this._reader = _reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        if (this.initialized) {
            return;
        }
        JSONFileRegionDataInput jSONFileRegionDataInput = this;
        synchronized (jSONFileRegionDataInput) {
            if (this.initialized) {
                return;
            }
            this.reader = this.filename == null ? new JSONReader(this._reader) : new JSONReader((Reader)new FileReader(this.filename));
            this.reader.startArray();
            this.initialized = true;
        }
    }

    @Override
    public RegionDTO read() throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        if (this.reader.hasNext()) {
            RegionDTO regionDTO = (RegionDTO)this.reader.readObject(RegionDTO.class);
            this.report.record(regionDTO);
            return regionDTO;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        LOG.info(this.report.report());
        try {
            this.reader.endArray();
        }
        finally {
            this.reader.close();
        }
    }
}

