/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.io.file;

import com.alibaba.fastjson.JSONWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.io.RegionDataOutput;
import tech.spiro.addrparser.io.RegionDataReport;

public class JSONFileRegionDataOutput
implements RegionDataOutput {
    private static final Logger LOG = LoggerFactory.getLogger(JSONFileRegionDataOutput.class);
    private Writer _writer;
    private String filename;
    private JSONWriter writer = null;
    private RegionDataReport report = new RegionDataReport();
    private boolean initialized = false;

    public JSONFileRegionDataOutput(String filename) {
        this.filename = filename;
        if (this.filename == null) {
            throw new IllegalArgumentException("<filename> cannot be null.");
        }
    }

    public JSONFileRegionDataOutput(Writer _writer) {
        this._writer = _writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        if (this.initialized) {
            return;
        }
        JSONFileRegionDataOutput jSONFileRegionDataOutput = this;
        synchronized (jSONFileRegionDataOutput) {
            if (this.initialized) {
                return;
            }
            this.writer = this.filename == null ? new JSONWriter(this._writer) : new JSONWriter((Writer)new FileWriter(this.filename));
            this.writer.config(SerializerFeature.WriteEnumUsingName, false);
            this.writer.config(SerializerFeature.SortField, false);
            this.writer.startArray();
            this.initialized = true;
        }
    }

    @Override
    public void write(RegionDTO regionDTO) throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        this.writer.writeValue((Object)regionDTO);
        this.report.record(regionDTO);
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        LOG.info(this.report.report());
        try {
            this.writer.endArray();
        }
        finally {
            this.writer.close();
        }
    }
}

