/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.io.rdbms;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.io.RegionDataInput;
import tech.spiro.addrparser.io.RegionDataReport;
import tech.spiro.addrparser.io.rdbms.RdbmsRegionDTOWrapper;
import tech.spiro.addrparser.io.rdbms.RdbmsSQL;

public class RdbmsRegionDataInput
implements RegionDataInput {
    private static final Logger LOG = LoggerFactory.getLogger(RdbmsRegionDataInput.class);
    private DataSource ds = null;
    private Connection conn = null;
    private PreparedStatement stmt = null;
    private ResultSet rs = null;
    private RegionDataReport report = new RegionDataReport();
    private boolean initialized = false;
    private final String sql;

    public RdbmsRegionDataInput(DataSource ds, String tableName) {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource:<ds> is null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("<tableName> is null.");
        }
        this.ds = ds;
        this.sql = RdbmsSQL.selectSQL(tableName);
    }

    public RdbmsRegionDataInput(DataSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource:<ds> is null.");
        }
        this.ds = ds;
        this.sql = RdbmsSQL.defaultSelectSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        if (this.initialized) {
            return;
        }
        RdbmsRegionDataInput rdbmsRegionDataInput = this;
        synchronized (rdbmsRegionDataInput) {
            if (this.initialized) {
                return;
            }
            LOG.debug("Initializing...sql: {}", (Object)this.sql);
            try {
                this.conn = this.ds.getConnection();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
            LOG.debug("Initializing: Get connection completely.");
            try {
                this.stmt = this.conn.prepareStatement(this.sql);
                this.rs = this.stmt.executeQuery();
            }
            catch (SQLException e) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new IOException(e.getMessage(), e);
            }
            LOG.debug("Initializing: Get preparedStatement/resultSet completely.");
            this.initialized = true;
            LOG.debug("Initialized.");
        }
    }

    @Override
    public RegionDTO read() throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        try {
            if (this.rs.next()) {
                RegionDTO regionDTO = new RegionDTO();
                RdbmsRegionDTOWrapper regionDTOWrapper = new RdbmsRegionDTOWrapper(regionDTO);
                regionDTOWrapper.read(this.rs);
                this.report.record(regionDTO);
                return regionDTO;
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        LOG.info(this.report.report());
        try {
            this.rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

