/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.tool;

import java.awt.Polygon;
import tech.spiro.addrparser.common.Point;

public class MapTools {
    private static double EARTH_RADIUS = 6378137.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getPoint2PointDistance(Point p1, Point p2) {
        double radLat1 = MapTools.rad(p1.getLat());
        double radLat2 = MapTools.rad(p2.getLat());
        double a = radLat1 - radLat2;
        double b = MapTools.rad(p1.getLon()) - MapTools.rad(p2.getLon());
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return s *= EARTH_RADIUS;
    }

    public static double getPoint2LineDistance(Point p, Point lineStartPoint, Point lineEndPoint) {
        double a = MapTools.getPoint2PointDistance(lineStartPoint, lineEndPoint);
        double b = MapTools.getPoint2PointDistance(p, lineStartPoint);
        double c = MapTools.getPoint2PointDistance(p, lineEndPoint);
        double cos\u03b1 = (Math.pow(a, 2.0) + Math.pow(b, 2.0) - Math.pow(c, 2.0)) / (2.0 * a * b);
        double cos\u03b2 = (Math.pow(a, 2.0) + Math.pow(c, 2.0) - Math.pow(b, 2.0)) / (2.0 * a * c);
        double distance = cos\u03b1 <= 0.0 ? b : (cos\u03b2 <= 0.0 ? c : Math.sqrt((a + b + c) * (a + b - c) * (a + c - b) * (b + c - a)) / (2.0 * a));
        return distance;
    }

    public static boolean inCircleArea(Point p, Point centerPoint, double radius) {
        double dis = MapTools.getPoint2PointDistance(p, centerPoint);
        return dis < radius;
    }

    public static boolean inRectangleArea(Point p, Point upLeftPoint, Point downRightPoint) {
        return p.getLon() > upLeftPoint.getLon() && p.getLon() < downRightPoint.getLon() && p.getLat() < upLeftPoint.getLat() && p.getLat() > downRightPoint.getLat();
    }

    public static boolean inPolygonArea(Point p, Point[] area) {
        Polygon pol = new Polygon();
        for (int i = 0; i < area.length; ++i) {
            pol.addPoint((int)(area[i].getLon() * 100000.0), (int)(area[i].getLat() * 100000.0));
        }
        return pol.contains((int)(p.getLon() * 100000.0), (int)(p.getLat() * 100000.0));
    }

    public static boolean yawing(Point p, Point[] line, double distance) {
        for (int i = 0; i < line.length - 1; ++i) {
            if (!(MapTools.getPoint2LineDistance(p, line[i], line[i + 1]) < distance)) continue;
            return false;
        }
        return true;
    }
}

