/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.WriteOptions;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.csv.CsvWriteOptions;
import tech.tablesaw.io.csv.CsvWriter;

public class DataFrameWriter {
    private final WriterRegistry registry;
    private final Table table;

    public DataFrameWriter(WriterRegistry registry, Table table) {
        this.registry = registry;
        this.table = table;
    }

    public void toFile(String file) {
        this.toFile(new File(file));
    }

    public void toFile(File file) {
        String extension = null;
        try {
            extension = Files.getFileExtension((String)file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        DataWriter<?> dataWriter = this.registry.getWriterForExtension(extension);
        dataWriter.write(this.table, new Destination(file));
    }

    public void toStream(OutputStream stream, String extension) {
        DataWriter<?> dataWriter = this.registry.getWriterForExtension(extension);
        dataWriter.write(this.table, new Destination(stream));
    }

    public void toWriter(Writer writer, String extension) {
        DataWriter<?> dataWriter = this.registry.getWriterForExtension(extension);
        dataWriter.write(this.table, new Destination(writer));
    }

    public <T extends WriteOptions> void usingOptions(T options) {
        DataWriter<T> dataWriter = this.registry.getWriterForOptions(options);
        dataWriter.write(this.table, options);
    }

    public String toString(String extension) {
        StringWriter writer = new StringWriter();
        DataWriter<?> dataWriter = this.registry.getWriterForExtension(extension);
        dataWriter.write(this.table, new Destination(writer));
        return writer.toString();
    }

    public void csv(String file) {
        CsvWriteOptions options = CsvWriteOptions.builder(file).build();
        new CsvWriter().write(this.table, options);
    }

    public void csv(File file) {
        CsvWriteOptions options = CsvWriteOptions.builder(file).build();
        new CsvWriter().write(this.table, options);
    }

    public void csv(CsvWriteOptions options) {
        new CsvWriter().write(this.table, options);
    }

    public void csv(OutputStream stream) {
        CsvWriteOptions options = CsvWriteOptions.builder(stream).build();
        new CsvWriter().write(this.table, options);
    }

    public void csv(Writer writer) {
        CsvWriteOptions options = CsvWriteOptions.builder(writer).build();
        new CsvWriter().write(this.table, options);
    }
}

