/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.TreeMap;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.InputCoercionException;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.exc.UnexpectedEndOfInputException;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.io.NumberOutput;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamWriteContext;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.cfg.PackageVersion;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.RawValue;
import tools.jackson.databind.util.TokenBufferReadContext;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_STREAM_WRITE_FEATURES = StreamWriteFeature.collectDefaults();
    protected static final JacksonFeatureSet<StreamWriteCapability> BOGUS_WRITE_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamWriteCapability.values());
    protected TokenStreamContext _parentContext;
    protected int _streamWriteFeatures;
    protected final StreamReadConstraints _streamReadConstraints;
    protected boolean _closed;
    protected boolean _hasNativeTypeIds;
    protected boolean _hasNativeObjectIds;
    protected boolean _mayHaveNativeIds;
    protected boolean _forceBigDecimal;
    protected Segment _first;
    protected Segment _last;
    protected int _appendAt;
    protected Object _typeId;
    protected Object _objectId;
    protected boolean _hasNativeId = false;
    protected SimpleStreamWriteContext _tokenWriteContext;
    protected ObjectWriteContext _objectWriteContext;

    @Deprecated
    public TokenBuffer(boolean hasNativeIds) {
        this._streamWriteFeatures = DEFAULT_STREAM_WRITE_FEATURES;
        this._tokenWriteContext = SimpleStreamWriteContext.createRootContext(null);
        this._first = this._last = new Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = hasNativeIds;
        this._hasNativeObjectIds = hasNativeIds;
        this._streamReadConstraints = StreamReadConstraints.defaults();
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
    }

    public TokenBuffer(ObjectWriteContext writeContext, boolean hasNativeIds) {
        this._objectWriteContext = writeContext;
        this._streamWriteFeatures = DEFAULT_STREAM_WRITE_FEATURES;
        this._tokenWriteContext = SimpleStreamWriteContext.createRootContext(null);
        this._streamReadConstraints = StreamReadConstraints.defaults();
        this._first = this._last = new Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = hasNativeIds;
        this._hasNativeObjectIds = hasNativeIds;
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
    }

    protected TokenBuffer(JsonParser p, ObjectReadContext ctxt) {
        this._parentContext = p.streamReadContext();
        this._streamReadConstraints = ctxt == null ? p.streamReadConstraints() : ctxt.streamReadConstraints();
        this._streamWriteFeatures = DEFAULT_STREAM_WRITE_FEATURES;
        this._tokenWriteContext = SimpleStreamWriteContext.createRootContext(null);
        this._first = this._last = new Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = p.canReadTypeId();
        this._hasNativeObjectIds = p.canReadObjectId();
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
        this._forceBigDecimal = ctxt instanceof DeserializationContext ? ((DeserializationContext)ctxt).isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) : false;
    }

    public static TokenBuffer forGeneration() {
        return new TokenBuffer(false);
    }

    public static TokenBuffer forBuffering(JsonParser p, ObjectReadContext ctxt) {
        return new TokenBuffer(p, ctxt);
    }

    public TokenBuffer overrideParentContext(TokenStreamContext ctxt) {
        this._parentContext = ctxt;
        return this;
    }

    public TokenBuffer forceUseOfBigDecimal(boolean b) {
        this._forceBigDecimal = b;
        return this;
    }

    public JsonParser asParser() {
        return new Parser(ObjectReadContext.empty(), this, this._first, this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext, this._streamReadConstraints);
    }

    public JsonParser asParser(ObjectReadContext readCtxt) {
        return new Parser(readCtxt, this, this._first, this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext, this._streamReadConstraints);
    }

    public JsonParser asParser(ObjectReadContext readCtxt, JsonParser p0) {
        StreamReadConstraints src = p0 == null ? this._streamReadConstraints : p0.streamReadConstraints();
        Parser p = new Parser(readCtxt, this, this._first, this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext, src);
        if (p0 != null) {
            p.setLocation(p0.currentTokenLocation());
        }
        return p;
    }

    public JsonParser asParserOnFirstToken(ObjectReadContext readCtxt) throws JacksonException {
        JsonParser p = this.asParser(readCtxt);
        p.nextToken();
        return p;
    }

    public JsonParser asParserOnFirstToken(ObjectReadContext readCtxt, JsonParser src) throws JacksonException {
        JsonParser p = this.asParser(readCtxt, src);
        p.nextToken();
        return p;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JsonToken firstToken() {
        return this._first.type(0);
    }

    public boolean isEmpty() {
        return this._appendAt == 0 && this._first == this._last;
    }

    public TokenBuffer append(TokenBuffer other) {
        if (!this._hasNativeTypeIds) {
            this._hasNativeTypeIds = other.canWriteTypeId();
        }
        if (!this._hasNativeObjectIds) {
            this._hasNativeObjectIds = other.canWriteObjectId();
        }
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
        JsonParser p = other.asParser();
        while (p.nextToken() != null) {
            this.copyCurrentStructure(p);
        }
        return this;
    }

    public void serialize(JsonGenerator gen) throws JacksonException {
        boolean hasIds;
        Segment segment = this._first;
        int ptr = -1;
        boolean checkIds = this._mayHaveNativeIds;
        boolean bl = hasIds = checkIds && segment.hasIds();
        while (true) {
            JsonToken t;
            if (++ptr >= 16) {
                ptr = 0;
                if ((segment = segment.next()) == null) break;
                boolean bl2 = hasIds = checkIds && segment.hasIds();
            }
            if ((t = segment.type(ptr)) == null) break;
            if (hasIds) {
                Object id = segment.findObjectId(ptr);
                if (id != null) {
                    gen.writeObjectId(id);
                }
                if ((id = segment.findTypeId(ptr)) != null) {
                    gen.writeTypeId(id);
                }
            }
            switch (t) {
                case START_OBJECT: {
                    gen.writeStartObject();
                    break;
                }
                case END_OBJECT: {
                    gen.writeEndObject();
                    break;
                }
                case START_ARRAY: {
                    gen.writeStartArray();
                    break;
                }
                case END_ARRAY: {
                    gen.writeEndArray();
                    break;
                }
                case PROPERTY_NAME: {
                    Object ob = segment.get(ptr);
                    if (ob instanceof SerializableString) {
                        gen.writeName((SerializableString)ob);
                        break;
                    }
                    gen.writeName((String)ob);
                    break;
                }
                case VALUE_STRING: {
                    Object ob = segment.get(ptr);
                    if (ob instanceof SerializableString) {
                        gen.writeString((SerializableString)ob);
                        break;
                    }
                    gen.writeString((String)ob);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    Object n = segment.get(ptr);
                    if (n instanceof Integer) {
                        gen.writeNumber(((Integer)n).intValue());
                        break;
                    }
                    if (n instanceof BigInteger) {
                        gen.writeNumber((BigInteger)n);
                        break;
                    }
                    if (n instanceof Long) {
                        gen.writeNumber(((Long)n).longValue());
                        break;
                    }
                    if (n instanceof Short) {
                        gen.writeNumber(((Short)n).shortValue());
                        break;
                    }
                    gen.writeNumber(((Number)n).intValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    Object n = segment.get(ptr);
                    if (n instanceof Double) {
                        gen.writeNumber(((Double)n).doubleValue());
                        break;
                    }
                    if (n instanceof BigDecimal) {
                        gen.writeNumber((BigDecimal)n);
                        break;
                    }
                    if (n instanceof Float) {
                        gen.writeNumber(((Float)n).floatValue());
                        break;
                    }
                    if (n == null) {
                        gen.writeNull();
                        break;
                    }
                    if (n instanceof String) {
                        gen.writeNumber((String)n);
                        break;
                    }
                    throw new StreamWriteException(gen, String.format("Unrecognized value type for VALUE_NUMBER_FLOAT: %s, cannot serialize", n.getClass().getName()));
                }
                case VALUE_TRUE: {
                    gen.writeBoolean(true);
                    break;
                }
                case VALUE_FALSE: {
                    gen.writeBoolean(false);
                    break;
                }
                case VALUE_NULL: {
                    gen.writeNull();
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object value = segment.get(ptr);
                    if (value instanceof RawValue) {
                        ((RawValue)value).serialize(gen);
                        break;
                    }
                    if (value instanceof JacksonSerializable) {
                        gen.writePOJO(value);
                        break;
                    }
                    gen.writeEmbeddedObject(value);
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: should never end up through this code path");
                }
            }
        }
    }

    public TokenBuffer deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JsonToken t;
        if (!p.hasToken(JsonToken.PROPERTY_NAME)) {
            this.copyCurrentStructure(p);
            return this;
        }
        this.writeStartObject();
        do {
            this.copyCurrentStructure(p);
        } while ((t = p.nextToken()) == JsonToken.PROPERTY_NAME);
        if (t != JsonToken.END_OBJECT) {
            ctxt.reportWrongTokenException(TokenBuffer.class, JsonToken.END_OBJECT, "Expected END_OBJECT after copying contents of a JsonParser into TokenBuffer, got " + String.valueOf(t), new Object[0]);
        }
        this.writeEndObject();
        return this;
    }

    public String toString() {
        JsonToken t;
        boolean hasNativeIds;
        int MAX_COUNT = 100;
        StringBuilder sb = new StringBuilder();
        sb.append("[TokenBuffer: ");
        JsonParser p = this.asParser();
        int count = 0;
        boolean bl = hasNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
        while ((t = p.nextToken()) != null) {
            if (count < 100) {
                if (count > 0) {
                    sb.append(", ");
                }
                if (hasNativeIds) {
                    this._appendNativeIds(sb);
                }
                sb.append(t.toString());
                if (t == JsonToken.PROPERTY_NAME) {
                    sb.append('(');
                    sb.append(p.currentName());
                    sb.append(')');
                }
            }
            ++count;
        }
        if (count >= 100) {
            sb.append(" ... (truncated ").append(count - 100).append(" entries)");
        }
        sb.append(']');
        return sb.toString();
    }

    private final void _appendNativeIds(StringBuilder sb) {
        Object typeId;
        Object objectId = this._last.findObjectId(this._appendAt - 1);
        if (objectId != null) {
            sb.append("[objectId=").append(String.valueOf(objectId)).append(']');
        }
        if ((typeId = this._last.findTypeId(this._appendAt - 1)) != null) {
            sb.append("[typeId=").append(String.valueOf(typeId)).append(']');
        }
    }

    public TokenStreamContext streamWriteContext() {
        return this._tokenWriteContext;
    }

    public Object currentValue() {
        return this._tokenWriteContext.currentValue();
    }

    public void assignCurrentValue(Object v) {
        this._tokenWriteContext.assignCurrentValue(v);
    }

    public ObjectWriteContext objectWriteContext() {
        return this._objectWriteContext;
    }

    public JsonGenerator configure(StreamWriteFeature f, boolean state) {
        this._streamWriteFeatures = state ? (this._streamWriteFeatures |= f.getMask()) : (this._streamWriteFeatures &= ~f.getMask());
        return this;
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return (this._streamWriteFeatures & f.getMask()) != 0;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return BOGUS_WRITE_CAPABILITIES;
    }

    public void flush() {
    }

    public void close() {
        this._closed = true;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public Object streamWriteOutputTarget() {
        return null;
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public final JsonGenerator writeStartArray() {
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._tokenWriteContext = this._tokenWriteContext.createChildArrayContext(null);
        return this;
    }

    public final JsonGenerator writeStartArray(Object forValue) {
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._tokenWriteContext = this._tokenWriteContext.createChildArrayContext(forValue);
        return this;
    }

    public final JsonGenerator writeStartArray(Object forValue, int len) {
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._tokenWriteContext = this._tokenWriteContext.createChildArrayContext(forValue);
        return this;
    }

    public final JsonGenerator writeEndArray() {
        this._appendEndMarker(JsonToken.END_ARRAY);
        return this;
    }

    public final JsonGenerator writeStartObject() {
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._tokenWriteContext = this._tokenWriteContext.createChildObjectContext(null);
        return this;
    }

    public JsonGenerator writeStartObject(Object forValue) {
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._tokenWriteContext = this._tokenWriteContext.createChildObjectContext(forValue);
        return this;
    }

    public JsonGenerator writeStartObject(Object forValue, int size) {
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._tokenWriteContext = this._tokenWriteContext.createChildObjectContext(forValue);
        return this;
    }

    public final JsonGenerator writeEndObject() {
        this._appendEndMarker(JsonToken.END_OBJECT);
        return this;
    }

    public final JsonGenerator writeName(String name) {
        this._tokenWriteContext.writeName(name);
        this._appendName(name);
        return this;
    }

    public JsonGenerator writeName(SerializableString name) {
        this._tokenWriteContext.writeName(name.getValue());
        this._appendName(name);
        return this;
    }

    public JsonGenerator writePropertyId(long id) {
        String name = Long.toString(id);
        this._tokenWriteContext.writeName(name);
        this._appendName(name);
        return this;
    }

    public JsonGenerator writeString(String text) {
        if (text == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_STRING, text);
        }
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) {
        return this.writeString(new String(text, offset, len));
    }

    public JsonGenerator writeString(SerializableString text) {
        if (text == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_STRING, text);
        }
        return this;
    }

    public JsonGenerator writeString(Reader reader, int len) {
        int toRead;
        int numRead;
        if (reader == null) {
            this._reportError("null reader");
        }
        char[] buf = new char[1000];
        StringBuilder sb = new StringBuilder(1000);
        for (toRead = len >= 0 ? len : Integer.MAX_VALUE; toRead > 0; toRead -= numRead) {
            int toReadNow = Math.min(toRead, buf.length);
            try {
                numRead = reader.read(buf, 0, toReadNow);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            if (numRead <= 0) break;
            sb.append(buf, 0, numRead);
        }
        if (toRead > 0 && len >= 0) {
            this._reportError("Was not able to read enough from reader");
        }
        this._appendValue(JsonToken.VALUE_STRING, sb.toString());
        return this;
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int length) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int length) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text, int offset, int len) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(SerializableString text) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char c) {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(text));
        return this;
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) {
        if (offset > 0 || len != text.length()) {
            text = text.substring(offset, offset + len);
        }
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(text));
        return this;
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new String(text, offset, len));
        return this;
    }

    public JsonGenerator writeNumber(short i) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, i);
        return this;
    }

    public JsonGenerator writeNumber(int i) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, i);
        return this;
    }

    public JsonGenerator writeNumber(long l) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, l);
        return this;
    }

    public JsonGenerator writeNumber(double d) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, d);
        return this;
    }

    public JsonGenerator writeNumber(float f) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, Float.valueOf(f));
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal dec) {
        if (dec == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, dec);
        }
        return this;
    }

    public JsonGenerator writeNumber(BigInteger v) {
        if (v == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_NUMBER_INT, v);
        }
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, encodedValue);
        return this;
    }

    public void writeNumber(String encodedValue, boolean isInteger) throws IOException {
        this._appendValue(isInteger ? JsonToken.VALUE_NUMBER_INT : JsonToken.VALUE_NUMBER_FLOAT, encodedValue);
    }

    private void writeLazyInteger(Object encodedValue) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, encodedValue);
    }

    private void writeLazyDecimal(Object encodedValue) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, encodedValue);
    }

    public JsonGenerator writeBoolean(boolean state) {
        this._appendValue(state ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
        return this;
    }

    public JsonGenerator writeNull() {
        this._appendValue(JsonToken.VALUE_NULL);
        return this;
    }

    public JsonGenerator writePOJO(Object value) {
        if (value == null) {
            return this.writeNull();
        }
        Class<?> raw = value.getClass();
        if (raw == byte[].class || value instanceof RawValue || this._objectWriteContext == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, value);
            return this;
        }
        this._objectWriteContext.writeValue((JsonGenerator)this, value);
        return this;
    }

    public JsonGenerator writeTree(TreeNode node) {
        if (node == null) {
            return this.writeNull();
        }
        if (this._objectWriteContext == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, node);
            return this;
        }
        this._objectWriteContext.writeTree((JsonGenerator)this, node);
        return this;
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) {
        byte[] copy = Arrays.copyOfRange(data, offset, offset + len);
        return this.writePOJO(copy);
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) {
        throw new UnsupportedOperationException();
    }

    public boolean canWriteTypeId() {
        return this._hasNativeTypeIds;
    }

    public boolean canWriteObjectId() {
        return this._hasNativeObjectIds;
    }

    public JsonGenerator writeTypeId(Object id) {
        this._typeId = id;
        this._hasNativeId = true;
        return this;
    }

    public JsonGenerator writeObjectId(Object id) {
        this._objectId = id;
        this._hasNativeId = true;
        return this;
    }

    public JsonGenerator writeEmbeddedObject(Object object) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
        return this;
    }

    public void copyCurrentEvent(JsonParser p) {
        if (this._mayHaveNativeIds) {
            this._checkNativeIds(p);
        }
        block0 : switch (p.currentToken()) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case PROPERTY_NAME: {
                this.writeName(p.currentName());
                break;
            }
            case VALUE_STRING: {
                if (p.hasStringCharacters()) {
                    this.writeString(p.getStringCharacters(), p.getStringOffset(), p.getStringLength());
                    break;
                }
                this.writeString(p.getString());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (p.getNumberType()) {
                    case INT: {
                        this.writeNumber(p.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeLazyInteger(p.getNumberValueDeferred());
                        break block0;
                    }
                }
                this.writeNumber(p.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.writeLazyDecimal(p.getNumberValueDeferred());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writePOJO(p.getEmbeddedObject());
                break;
            }
            default: {
                throw new RuntimeException("Internal error: unexpected token: " + String.valueOf(p.currentToken()));
            }
        }
    }

    public void copyCurrentStructure(JsonParser p) {
        JsonToken t = p.currentToken();
        if (t == JsonToken.PROPERTY_NAME) {
            if (this._mayHaveNativeIds) {
                this._checkNativeIds(p);
            }
            this.writeName(p.currentName());
            t = p.nextToken();
        } else if (t == null) {
            throw new UnexpectedEndOfInputException(p, null, "Unexpected end-of-input");
        }
        switch (t) {
            case START_ARRAY: {
                if (this._mayHaveNativeIds) {
                    this._checkNativeIds(p);
                }
                this.writeStartArray();
                this._copyBufferContents(p);
                break;
            }
            case START_OBJECT: {
                if (this._mayHaveNativeIds) {
                    this._checkNativeIds(p);
                }
                this.writeStartObject();
                this._copyBufferContents(p);
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            default: {
                this._copyBufferValue(p, t);
            }
        }
    }

    protected void _copyBufferContents(JsonParser p) {
        JsonToken t;
        int depth = 1;
        block7: while ((t = p.nextToken()) != null) {
            switch (t) {
                case PROPERTY_NAME: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(p);
                    }
                    this.writeName(p.currentName());
                    continue block7;
                }
                case START_ARRAY: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(p);
                    }
                    this.writeStartArray();
                    ++depth;
                    continue block7;
                }
                case START_OBJECT: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(p);
                    }
                    this.writeStartObject();
                    ++depth;
                    continue block7;
                }
                case END_ARRAY: {
                    this.writeEndArray();
                    if (--depth != 0) continue block7;
                    return;
                }
                case END_OBJECT: {
                    this.writeEndObject();
                    if (--depth != 0) continue block7;
                    return;
                }
            }
            this._copyBufferValue(p, t);
        }
    }

    private void _copyBufferValue(JsonParser p, JsonToken t) {
        if (this._mayHaveNativeIds) {
            this._checkNativeIds(p);
        }
        block0 : switch (t) {
            case VALUE_STRING: {
                if (p.hasStringCharacters()) {
                    this.writeString(p.getStringCharacters(), p.getStringOffset(), p.getStringLength());
                    break;
                }
                this.writeString(p.getString());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (p.getNumberType()) {
                    case INT: {
                        this.writeNumber(p.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeLazyInteger(p.getNumberValueDeferred());
                        break block0;
                    }
                }
                this.writeNumber(p.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.writeLazyDecimal(p.getNumberValueDeferred());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writePOJO(p.getEmbeddedObject());
                break;
            }
            default: {
                throw new RuntimeException("Internal error: unexpected token: " + String.valueOf(t));
            }
        }
    }

    private final void _checkNativeIds(JsonParser p) {
        this._typeId = p.getTypeId();
        if (this._typeId != null) {
            this._hasNativeId = true;
        }
        if ((this._objectId = p.getObjectId()) != null) {
            this._hasNativeId = true;
        }
    }

    protected final void _appendValue(JsonToken type) {
        this._tokenWriteContext.writeValue();
        Segment next = this._hasNativeId ? this._last.append(this._appendAt, type, this._objectId, this._typeId) : this._last.append(this._appendAt, type);
        if (next == null) {
            ++this._appendAt;
        } else {
            this._last = next;
            this._appendAt = 1;
        }
    }

    protected final void _appendValue(JsonToken type, Object value) {
        this._tokenWriteContext.writeValue();
        Segment next = this._hasNativeId ? this._last.append(this._appendAt, type, value, this._objectId, this._typeId) : this._last.append(this._appendAt, type, value);
        if (next == null) {
            ++this._appendAt;
        } else {
            this._last = next;
            this._appendAt = 1;
        }
    }

    protected final void _appendName(Object value) {
        Segment next = this._hasNativeId ? this._last.append(this._appendAt, JsonToken.PROPERTY_NAME, value, this._objectId, this._typeId) : this._last.append(this._appendAt, JsonToken.PROPERTY_NAME, value);
        if (next == null) {
            ++this._appendAt;
        } else {
            this._last = next;
            this._appendAt = 1;
        }
    }

    protected final void _appendStartMarker(JsonToken type) {
        this._tokenWriteContext.writeValue();
        Segment next = this._hasNativeId ? this._last.append(this._appendAt, type, this._objectId, this._typeId) : this._last.append(this._appendAt, type);
        if (next == null) {
            ++this._appendAt;
        } else {
            this._last = next;
            this._appendAt = 1;
        }
    }

    protected final void _appendEndMarker(JsonToken type) {
        Segment next = this._last.append(this._appendAt, type);
        if (next == null) {
            ++this._appendAt;
        } else {
            this._last = next;
            this._appendAt = 1;
        }
        SimpleStreamWriteContext c = this._tokenWriteContext.getParent();
        if (c != null) {
            this._tokenWriteContext = c;
        }
    }

    protected <T> T _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }

    protected static final class Segment {
        public static final int TOKENS_PER_SEGMENT = 16;
        private static final JsonToken[] TOKEN_TYPES_BY_INDEX = new JsonToken[16];
        protected Segment _next;
        protected long _tokenTypes;
        protected final Object[] _tokens = new Object[16];
        protected TreeMap<Integer, Object> _nativeIds;

        public JsonToken type(int index) {
            long l = this._tokenTypes;
            if (index > 0) {
                l >>= index << 2;
            }
            int ix = (int)l & 0xF;
            return TOKEN_TYPES_BY_INDEX[ix];
        }

        public int rawType(int index) {
            long l = this._tokenTypes;
            if (index > 0) {
                l >>= index << 2;
            }
            return (int)l & 0xF;
        }

        public Object get(int index) {
            return this._tokens[index];
        }

        public Segment next() {
            return this._next;
        }

        public boolean hasIds() {
            return this._nativeIds != null;
        }

        public Segment append(int index, JsonToken tokenType) {
            if (index < 16) {
                this.set(index, tokenType);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, tokenType);
            return this._next;
        }

        public Segment append(int index, JsonToken tokenType, Object objectId, Object typeId) {
            if (index < 16) {
                this.set(index, tokenType, objectId, typeId);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, tokenType, objectId, typeId);
            return this._next;
        }

        public Segment append(int index, JsonToken tokenType, Object value) {
            if (index < 16) {
                this.set(index, tokenType, value);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, tokenType, value);
            return this._next;
        }

        public Segment append(int index, JsonToken tokenType, Object value, Object objectId, Object typeId) {
            if (index < 16) {
                this.set(index, tokenType, value, objectId, typeId);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, tokenType, value, objectId, typeId);
            return this._next;
        }

        private void set(int index, JsonToken tokenType) {
            long typeCode = tokenType.ordinal();
            if (index > 0) {
                typeCode <<= index << 2;
            }
            this._tokenTypes |= typeCode;
        }

        private void set(int index, JsonToken tokenType, Object objectId, Object typeId) {
            long typeCode = tokenType.ordinal();
            if (index > 0) {
                typeCode <<= index << 2;
            }
            this._tokenTypes |= typeCode;
            this.assignNativeIds(index, objectId, typeId);
        }

        private void set(int index, JsonToken tokenType, Object value) {
            this._tokens[index] = value;
            long typeCode = tokenType.ordinal();
            if (index > 0) {
                typeCode <<= index << 2;
            }
            this._tokenTypes |= typeCode;
        }

        private void set(int index, JsonToken tokenType, Object value, Object objectId, Object typeId) {
            this._tokens[index] = value;
            long typeCode = tokenType.ordinal();
            if (index > 0) {
                typeCode <<= index << 2;
            }
            this._tokenTypes |= typeCode;
            this.assignNativeIds(index, objectId, typeId);
        }

        private final void assignNativeIds(int index, Object objectId, Object typeId) {
            if (this._nativeIds == null) {
                this._nativeIds = new TreeMap();
            }
            if (objectId != null) {
                this._nativeIds.put(this._objectIdIndex(index), objectId);
            }
            if (typeId != null) {
                this._nativeIds.put(this._typeIdIndex(index), typeId);
            }
        }

        public Object findObjectId(int index) {
            return this._nativeIds == null ? null : this._nativeIds.get(this._objectIdIndex(index));
        }

        public Object findTypeId(int index) {
            return this._nativeIds == null ? null : this._nativeIds.get(this._typeIdIndex(index));
        }

        private final int _typeIdIndex(int i) {
            return i + i;
        }

        private final int _objectIdIndex(int i) {
            return i + i + 1;
        }

        static {
            JsonToken[] t = JsonToken.values();
            System.arraycopy(t, 1, TOKEN_TYPES_BY_INDEX, 1, Math.min(15, t.length - 1));
        }
    }

    protected static final class Parser
    extends ParserMinimalBase {
        protected StreamReadConstraints _streamReadConstraints;
        protected final TokenBuffer _source;
        protected final boolean _hasNativeTypeIds;
        protected final boolean _hasNativeObjectIds;
        protected final boolean _hasNativeIds;
        protected Segment _segment;
        protected int _segmentPtr;
        protected TokenBufferReadContext _parsingContext;
        protected boolean _closed;
        protected transient ByteArrayBuilder _byteBuilder;
        protected TokenStreamLocation _location = null;

        public Parser(ObjectReadContext readCtxt, TokenBuffer source, Segment firstSeg, boolean hasNativeTypeIds, boolean hasNativeObjectIds, TokenStreamContext parentContext, StreamReadConstraints streamReadConstraints) {
            super(readCtxt);
            this._source = source;
            this._segment = firstSeg;
            this._segmentPtr = -1;
            this._streamReadConstraints = streamReadConstraints;
            this._parsingContext = TokenBufferReadContext.createRootContext(parentContext);
            this._hasNativeTypeIds = hasNativeTypeIds;
            this._hasNativeObjectIds = hasNativeObjectIds;
            this._hasNativeIds = hasNativeTypeIds || hasNativeObjectIds;
        }

        public void setLocation(TokenStreamLocation l) {
            this._location = l;
        }

        public Version version() {
            return PackageVersion.VERSION;
        }

        public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
            return DEFAULT_READ_CAPABILITIES;
        }

        public TokenBuffer streamReadInputSource() {
            return this._source;
        }

        public StreamReadConstraints streamReadConstraints() {
            return this._streamReadConstraints;
        }

        public JsonToken peekNextToken() {
            if (this._closed) {
                return null;
            }
            Segment seg = this._segment;
            int ptr = this._segmentPtr + 1;
            if (ptr >= 16) {
                ptr = 0;
                seg = seg == null ? null : seg.next();
            }
            return seg == null ? null : seg.type(ptr);
        }

        public void close() {
            this._closed = true;
        }

        protected void _closeInput() throws IOException {
        }

        protected void _releaseBuffers() {
        }

        public JsonToken nextToken() {
            if (this._closed || this._segment == null) {
                this._updateTokenToNull();
                return null;
            }
            if (++this._segmentPtr >= 16) {
                this._segmentPtr = 0;
                this._segment = this._segment.next();
                if (this._segment == null) {
                    this._updateTokenToNull();
                    return null;
                }
            }
            this._updateToken(this._segment.type(this._segmentPtr));
            if (this._currToken == JsonToken.PROPERTY_NAME) {
                Object ob = this._currentObject();
                String name = ob instanceof String ? (String)ob : ob.toString();
                this._parsingContext.setCurrentName(name);
            } else if (this._currToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext();
            } else if (this._currToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext();
            } else if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
                this._parsingContext = this._parsingContext.parentOrCopy();
            } else {
                this._parsingContext.updateForValue();
            }
            return this._currToken;
        }

        public String nextName() {
            if (this._closed || this._segment == null) {
                return null;
            }
            int ptr = this._segmentPtr + 1;
            if (ptr < 16 && this._segment.type(ptr) == JsonToken.PROPERTY_NAME) {
                this._segmentPtr = ptr;
                this._updateToken(JsonToken.PROPERTY_NAME);
                Object ob = this._segment.get(ptr);
                String name = ob instanceof String ? (String)ob : ob.toString();
                this._parsingContext.setCurrentName(name);
                return name;
            }
            return this.nextToken() == JsonToken.PROPERTY_NAME ? this.currentName() : null;
        }

        public int nextNameMatch(PropertyNameMatcher matcher) {
            String str = this.nextName();
            if (str != null) {
                return matcher.matchName(str);
            }
            if (this.hasToken(JsonToken.END_OBJECT)) {
                return -1;
            }
            return -3;
        }

        public boolean isClosed() {
            return this._closed;
        }

        public TokenStreamContext streamReadContext() {
            return this._parsingContext;
        }

        public void assignCurrentValue(Object v) {
            this._parsingContext.assignCurrentValue(v);
        }

        public Object currentValue() {
            return this._parsingContext.currentValue();
        }

        public TokenStreamLocation currentTokenLocation() {
            return this.currentLocation();
        }

        public TokenStreamLocation currentLocation() {
            return this._location == null ? TokenStreamLocation.NA : this._location;
        }

        public String currentName() {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                TokenStreamContext parent = this._parsingContext.getParent();
                return parent.currentName();
            }
            return this._parsingContext.currentName();
        }

        public String getString() {
            if (this._currToken == JsonToken.VALUE_STRING || this._currToken == JsonToken.PROPERTY_NAME) {
                Object ob = this._currentObject();
                if (ob instanceof String) {
                    return (String)ob;
                }
                return ClassUtil.nullOrToString(ob);
            }
            if (this._currToken == null) {
                return null;
            }
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return ClassUtil.nullOrToString(this._currentObject());
                }
            }
            return this._currToken.asString();
        }

        public char[] getStringCharacters() {
            String str = this.getString();
            return str == null ? null : str.toCharArray();
        }

        public int getStringLength() {
            String str = this.getString();
            return str == null ? 0 : str.length();
        }

        public int getStringOffset() {
            return 0;
        }

        public boolean hasStringCharacters() {
            return false;
        }

        public boolean isNaN() {
            if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                Object value = this._currentObject();
                if (value instanceof Double) {
                    return NumberOutput.notFinite((double)((Double)value));
                }
                if (value instanceof Float) {
                    return NumberOutput.notFinite((float)((Float)value).floatValue());
                }
            }
            return false;
        }

        public BigInteger getBigIntegerValue() {
            Number n = this._numberValue(4, true);
            if (n instanceof BigInteger) {
                return (BigInteger)n;
            }
            if (n instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)n;
                this.streamReadConstraints().validateBigIntegerScale(bd.scale());
                return bd.toBigInteger();
            }
            return BigInteger.valueOf(n.longValue());
        }

        public BigDecimal getDecimalValue() {
            Number n = this._numberValue(16, true);
            if (n instanceof BigDecimal) {
                return (BigDecimal)n;
            }
            if (n instanceof Integer) {
                return BigDecimal.valueOf(n.intValue());
            }
            if (n instanceof Long) {
                return BigDecimal.valueOf(n.longValue());
            }
            if (n instanceof BigInteger) {
                return new BigDecimal((BigInteger)n);
            }
            return BigDecimal.valueOf(n.doubleValue());
        }

        public double getDoubleValue() {
            return this._numberValue(8, false).doubleValue();
        }

        public float getFloatValue() {
            return this._numberValue(32, false).floatValue();
        }

        public int getIntValue() {
            Number n = this._numberValue(1, false);
            if (n instanceof Integer || this._smallerThanInt(n)) {
                return n.intValue();
            }
            return this._convertNumberToInt(n);
        }

        public long getLongValue() {
            Number n = this._numberValue(2, false);
            if (n instanceof Long || this._smallerThanLong(n)) {
                return n.longValue();
            }
            return this._convertNumberToLong(n);
        }

        public JsonParser.NumberType getNumberType() {
            if (this._currToken == null) {
                return null;
            }
            Object value = this._currentObject();
            if (value instanceof Number) {
                Number n = (Number)value;
                if (n instanceof Integer) {
                    return JsonParser.NumberType.INT;
                }
                if (n instanceof Long) {
                    return JsonParser.NumberType.LONG;
                }
                if (n instanceof Double) {
                    return JsonParser.NumberType.DOUBLE;
                }
                if (n instanceof BigDecimal) {
                    return JsonParser.NumberType.BIG_DECIMAL;
                }
                if (n instanceof BigInteger) {
                    return JsonParser.NumberType.BIG_INTEGER;
                }
                if (n instanceof Float) {
                    return JsonParser.NumberType.FLOAT;
                }
                if (n instanceof Short) {
                    return JsonParser.NumberType.INT;
                }
            } else if (value instanceof String) {
                return this._currToken == JsonToken.VALUE_NUMBER_FLOAT ? JsonParser.NumberType.BIG_DECIMAL : JsonParser.NumberType.BIG_INTEGER;
            }
            return null;
        }

        public JsonParser.NumberTypeFP getNumberTypeFP() {
            if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                Object n = this._currentObject();
                if (n instanceof Double) {
                    return JsonParser.NumberTypeFP.DOUBLE64;
                }
                if (n instanceof BigDecimal) {
                    return JsonParser.NumberTypeFP.BIG_DECIMAL;
                }
                if (n instanceof Float) {
                    return JsonParser.NumberTypeFP.FLOAT32;
                }
            }
            return JsonParser.NumberTypeFP.UNKNOWN;
        }

        public final Number getNumberValue() {
            return this._numberValue(-1, false);
        }

        public Object getNumberValueDeferred() {
            if (this._currToken == null || !this._currToken.isNumeric()) {
                throw this._constructNotNumericType(this._currToken, 0);
            }
            return this._currentObject();
        }

        private Number _numberValue(int targetNumType, boolean preferBigNumbers) {
            if (this._currToken == null || !this._currToken.isNumeric()) {
                throw this._constructNotNumericType(this._currToken, targetNumType);
            }
            Object value = this._currentObject();
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof String) {
                String str = (String)value;
                int len = str.length();
                if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
                    if (preferBigNumbers || len >= 19) {
                        return NumberInput.parseBigInteger((String)str, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    }
                    if (len >= 10) {
                        return NumberInput.parseLong((String)str);
                    }
                    return NumberInput.parseInt((String)str);
                }
                if (preferBigNumbers) {
                    BigDecimal dec = NumberInput.parseBigDecimal((String)str, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    if (dec == null) {
                        throw new IllegalStateException("Internal error: failed to parse number '" + str + "'");
                    }
                    return dec;
                }
                return NumberInput.parseDouble((String)str, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            throw new IllegalStateException("Internal error: entry should be a Number, but is of type " + ClassUtil.classNameOf(value));
        }

        private final boolean _smallerThanInt(Number n) {
            return n instanceof Short || n instanceof Byte;
        }

        private final boolean _smallerThanLong(Number n) {
            return n instanceof Integer || n instanceof Short || n instanceof Byte;
        }

        protected int _convertNumberToInt(Number n) throws InputCoercionException {
            if (n instanceof Long) {
                long l = n.longValue();
                int result = (int)l;
                if ((long)result != l) {
                    this._reportOverflowInt();
                }
                return result;
            }
            if (n instanceof BigInteger) {
                BigInteger big = (BigInteger)n;
                if (BI_MIN_INT.compareTo(big) > 0 || BI_MAX_INT.compareTo(big) < 0) {
                    this._reportOverflowInt();
                }
            } else {
                if (n instanceof Double || n instanceof Float) {
                    double d = n.doubleValue();
                    if (d < -2.147483648E9 || d > 2.147483647E9) {
                        this._reportOverflowInt();
                    }
                    return (int)d;
                }
                if (n instanceof BigDecimal) {
                    BigDecimal big = (BigDecimal)n;
                    if (BD_MIN_INT.compareTo(big) > 0 || BD_MAX_INT.compareTo(big) < 0) {
                        this._reportOverflowInt();
                    }
                } else {
                    this._throwInternal();
                }
            }
            return n.intValue();
        }

        protected long _convertNumberToLong(Number n) throws InputCoercionException {
            if (n instanceof BigInteger) {
                BigInteger big = (BigInteger)n;
                if (BI_MIN_LONG.compareTo(big) > 0 || BI_MAX_LONG.compareTo(big) < 0) {
                    this._reportOverflowLong();
                }
            } else {
                if (n instanceof Double || n instanceof Float) {
                    double d = n.doubleValue();
                    if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                        this._reportOverflowLong();
                    }
                    return (long)d;
                }
                if (n instanceof BigDecimal) {
                    BigDecimal big = (BigDecimal)n;
                    if (BD_MIN_LONG.compareTo(big) > 0 || BD_MAX_LONG.compareTo(big) < 0) {
                        this._reportOverflowLong();
                    }
                } else {
                    this._throwInternal();
                }
            }
            return n.longValue();
        }

        public Object getEmbeddedObject() {
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return this._currentObject();
            }
            return null;
        }

        public byte[] getBinaryValue(Base64Variant b64variant) throws JacksonException {
            Object ob;
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (ob = this._currentObject()) instanceof byte[]) {
                return (byte[])ob;
            }
            if (this._currToken != JsonToken.VALUE_STRING) {
                throw this._constructReadException("Current token (" + String.valueOf(this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), cannot access as binary");
            }
            String str = this.getString();
            if (str == null) {
                return null;
            }
            ByteArrayBuilder builder = this._byteBuilder;
            if (builder == null) {
                this._byteBuilder = builder = new ByteArrayBuilder(100);
            } else {
                this._byteBuilder.reset();
            }
            this._decodeBase64(str, builder, b64variant);
            return builder.toByteArray();
        }

        public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws JacksonException {
            byte[] data = this.getBinaryValue(b64variant);
            if (data != null) {
                try {
                    out.write(data, 0, data.length);
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
                return data.length;
            }
            return 0;
        }

        public boolean canReadObjectId() {
            return this._hasNativeObjectIds;
        }

        public boolean canReadTypeId() {
            return this._hasNativeTypeIds;
        }

        public Object getTypeId() {
            return this._segment.findTypeId(this._segmentPtr);
        }

        public Object getObjectId() {
            return this._segment.findObjectId(this._segmentPtr);
        }

        protected final Object _currentObject() {
            return this._segment.get(this._segmentPtr);
        }

        protected void _handleEOF() {
            this._throwInternal();
        }
    }
}

