/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.ValueInstantiators;
import tools.jackson.databind.deser.std.StdValueInstantiator;
import tools.jackson.databind.ext.javatime.deser.DurationDeserializer;
import tools.jackson.databind.ext.javatime.deser.InstantDeserializer;
import tools.jackson.databind.ext.javatime.deser.JSR310StringParsableDeserializer;
import tools.jackson.databind.ext.javatime.deser.LocalDateDeserializer;
import tools.jackson.databind.ext.javatime.deser.LocalDateTimeDeserializer;
import tools.jackson.databind.ext.javatime.deser.LocalTimeDeserializer;
import tools.jackson.databind.ext.javatime.deser.MonthDayDeserializer;
import tools.jackson.databind.ext.javatime.deser.MonthDeserializer;
import tools.jackson.databind.ext.javatime.deser.OffsetTimeDeserializer;
import tools.jackson.databind.ext.javatime.deser.YearDeserializer;
import tools.jackson.databind.ext.javatime.deser.YearMonthDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.DurationKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.InstantKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.LocalDateKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.LocalDateTimeKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.LocalTimeKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.MonthDayKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.OffsetDateTimeKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.OffsetTimeKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.PeriodKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.YearKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.YearMonthKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.ZoneIdKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.ZoneOffsetKeyDeserializer;
import tools.jackson.databind.ext.javatime.deser.key.ZonedDateTimeKeyDeserializer;
import tools.jackson.databind.ext.javatime.ser.DurationSerializer;
import tools.jackson.databind.ext.javatime.ser.InstantSerializer;
import tools.jackson.databind.ext.javatime.ser.LocalDateSerializer;
import tools.jackson.databind.ext.javatime.ser.LocalDateTimeSerializer;
import tools.jackson.databind.ext.javatime.ser.LocalTimeSerializer;
import tools.jackson.databind.ext.javatime.ser.MonthDaySerializer;
import tools.jackson.databind.ext.javatime.ser.MonthSerializer;
import tools.jackson.databind.ext.javatime.ser.OffsetDateTimeSerializer;
import tools.jackson.databind.ext.javatime.ser.OffsetTimeSerializer;
import tools.jackson.databind.ext.javatime.ser.YearMonthSerializer;
import tools.jackson.databind.ext.javatime.ser.YearSerializer;
import tools.jackson.databind.ext.javatime.ser.ZoneIdSerializer;
import tools.jackson.databind.ext.javatime.ser.ZonedDateTimeSerializer;
import tools.jackson.databind.ext.javatime.ser.key.ZonedDateTimeKeySerializer;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedClassResolver;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.module.SimpleKeyDeserializers;
import tools.jackson.databind.module.SimpleSerializers;
import tools.jackson.databind.ser.std.ToStringSerializer;

public final class JavaTimeInitializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final JavaTimeInitializer INSTANCE = new JavaTimeInitializer();

    public static JavaTimeInitializer getInstance() {
        return INSTANCE;
    }

    private JavaTimeInitializer() {
    }

    public void setupModule(JacksonModule.SetupContext context) {
        context.addDeserializers(new SimpleDeserializers().addDeserializer(Instant.class, InstantDeserializer.INSTANT).addDeserializer(OffsetDateTime.class, InstantDeserializer.OFFSET_DATE_TIME).addDeserializer(ZonedDateTime.class, InstantDeserializer.ZONED_DATE_TIME).addDeserializer(Duration.class, DurationDeserializer.INSTANCE).addDeserializer(LocalDateTime.class, LocalDateTimeDeserializer.INSTANCE).addDeserializer(LocalDate.class, LocalDateDeserializer.INSTANCE).addDeserializer(LocalTime.class, LocalTimeDeserializer.INSTANCE).addDeserializer(Month.class, MonthDeserializer.INSTANCE).addDeserializer(MonthDay.class, MonthDayDeserializer.INSTANCE).addDeserializer(OffsetTime.class, OffsetTimeDeserializer.INSTANCE).addDeserializer(Period.class, JSR310StringParsableDeserializer.PERIOD).addDeserializer(Year.class, YearDeserializer.INSTANCE).addDeserializer(YearMonth.class, YearMonthDeserializer.INSTANCE).addDeserializer(ZoneId.class, JSR310StringParsableDeserializer.ZONE_ID).addDeserializer(ZoneOffset.class, JSR310StringParsableDeserializer.ZONE_OFFSET));
        context.addSerializers(new SimpleSerializers().addSerializer(Duration.class, DurationSerializer.INSTANCE).addSerializer(Instant.class, InstantSerializer.INSTANCE).addSerializer(LocalDateTime.class, LocalDateTimeSerializer.INSTANCE).addSerializer(LocalDate.class, LocalDateSerializer.INSTANCE).addSerializer(LocalTime.class, LocalTimeSerializer.INSTANCE).addSerializer(Month.class, MonthSerializer.INSTANCE).addSerializer(MonthDay.class, MonthDaySerializer.INSTANCE).addSerializer(OffsetDateTime.class, OffsetDateTimeSerializer.INSTANCE).addSerializer(OffsetTime.class, OffsetTimeSerializer.INSTANCE).addSerializer(Period.class, new ToStringSerializer(Period.class)).addSerializer(Year.class, YearSerializer.INSTANCE).addSerializer(YearMonth.class, YearMonthSerializer.INSTANCE).addSerializer(ZonedDateTime.class, ZonedDateTimeSerializer.INSTANCE).addSerializer(ZoneId.class, new ZoneIdSerializer()).addSerializer(ZoneOffset.class, new ToStringSerializer(ZoneOffset.class)));
        context.addKeySerializers(new SimpleSerializers().addSerializer(ZonedDateTime.class, ZonedDateTimeKeySerializer.INSTANCE));
        context.addKeyDeserializers(new SimpleKeyDeserializers().addDeserializer(Duration.class, DurationKeyDeserializer.INSTANCE).addDeserializer(Instant.class, InstantKeyDeserializer.INSTANCE).addDeserializer(LocalDateTime.class, LocalDateTimeKeyDeserializer.INSTANCE).addDeserializer(LocalDate.class, LocalDateKeyDeserializer.INSTANCE).addDeserializer(LocalTime.class, LocalTimeKeyDeserializer.INSTANCE).addDeserializer(MonthDay.class, MonthDayKeyDeserializer.INSTANCE).addDeserializer(OffsetDateTime.class, OffsetDateTimeKeyDeserializer.INSTANCE).addDeserializer(OffsetTime.class, OffsetTimeKeyDeserializer.INSTANCE).addDeserializer(Period.class, PeriodKeyDeserializer.INSTANCE).addDeserializer(Year.class, YearKeyDeserializer.INSTANCE).addDeserializer(YearMonth.class, YearMonthKeyDeserializer.INSTANCE).addDeserializer(ZonedDateTime.class, ZonedDateTimeKeyDeserializer.INSTANCE).addDeserializer(ZoneId.class, ZoneIdKeyDeserializer.INSTANCE).addDeserializer(ZoneOffset.class, ZoneOffsetKeyDeserializer.INSTANCE));
        context.addValueInstantiators(new ValueInstantiators.Base(){

            @Override
            public ValueInstantiator modifyValueInstantiator(DeserializationConfig config, BeanDescription.Supplier beanDescRef, ValueInstantiator defaultInstantiator) {
                JavaType type = beanDescRef.getType();
                Class<?> raw = type.getRawClass();
                if (ZoneId.class.isAssignableFrom(raw) && defaultInstantiator instanceof StdValueInstantiator) {
                    AnnotatedMethod factory;
                    StdValueInstantiator inst = (StdValueInstantiator)defaultInstantiator;
                    AnnotatedClass ac = raw == ZoneId.class ? beanDescRef.getClassInfo() : AnnotatedClassResolver.resolve(config, config.constructType(ZoneId.class), config);
                    if (!inst.canCreateFromString() && (factory = JavaTimeInitializer.this._findFactory(ac, "of", String.class)) != null) {
                        inst.configureFromStringCreator(factory);
                    }
                }
                return defaultInstantiator;
            }
        });
    }

    private AnnotatedMethod _findFactory(AnnotatedClass cls, String name, Class<?> ... argTypes) {
        int argCount = argTypes.length;
        for (AnnotatedMethod method : cls.getFactoryMethods()) {
            if (!name.equals(method.getName()) || method.getParameterCount() != argCount) continue;
            for (int i = 0; i < argCount; ++i) {
                Class<?> argType = method.getParameter(i).getRawType();
                if (argType.isAssignableFrom(argTypes[i])) continue;
            }
            return method;
        }
        return null;
    }
}

