/*
 * Decompiled with CFR 0.152.
 */
package top.javatool.canal.client.factory;

import top.javatool.canal.client.enums.TableNameEnum;
import top.javatool.canal.client.factory.IModelFactory;
import top.javatool.canal.client.handler.EntryHandler;
import top.javatool.canal.client.util.GenericUtil;
import top.javatool.canal.client.util.HandlerUtil;

public abstract class AbstractModelFactory<T>
implements IModelFactory<T> {
    @Override
    public <R> R newInstance(EntryHandler entryHandler, T t) throws Exception {
        String canalTableName = HandlerUtil.getCanalTableName(entryHandler);
        if (TableNameEnum.ALL.name().toLowerCase().equals(canalTableName)) {
            return (R)t;
        }
        Class tableClass = GenericUtil.getTableClass(entryHandler);
        if (tableClass != null) {
            return (R)this.newInstance(tableClass, t);
        }
        return null;
    }

    abstract <R> R newInstance(Class<R> var1, T var2) throws Exception;
}

