/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.sysoutslf4j.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import uk.org.lidalia.sysoutslf4j.common.ExceptionUtils;
import uk.org.lidalia.sysoutslf4j.common.ProxyingInvocationHandler;
import uk.org.lidalia.sysoutslf4j.common.WrappedCheckedException;

public final class ReflectionUtils {
    public static Object invokeMethod(String methodName, Object target) {
        Method method = ReflectionUtils.getMethod(methodName, target.getClass(), new Class[0]);
        return ReflectionUtils.invokeMethod(method, target, new Object[0]);
    }

    public static Object invokeMethod(String methodName, Object target, Class<?> argType, Object arg) {
        Method method = ReflectionUtils.getMethod(methodName, target.getClass(), argType);
        return ReflectionUtils.invokeMethod(method, target, arg);
    }

    public static Object invokeStaticMethod(String methodName, Class<?> targetClass) {
        Method method = ReflectionUtils.getMethod(methodName, targetClass, new Class[0]);
        return ReflectionUtils.invokeMethod(method, targetClass, new Object[0]);
    }

    public static Object invokeStaticMethod(String methodName, Class<?> targetClass, Class<?> argType, Object arg) {
        Method method = ReflectionUtils.getMethod(methodName, targetClass, argType);
        return ReflectionUtils.invokeMethod(method, targetClass, arg);
    }

    private static Method getMethod(String methodName, Class<?> classWithMethod, Class<?> ... argTypes) {
        try {
            return ReflectionUtils.getMethod(methodName, classWithMethod, argTypes, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new WrappedCheckedException(noSuchMethodException);
        }
    }

    private static Method getMethod(String methodName, Class<?> classWithMethod, Class<?>[] argTypes, NoSuchMethodException originalNoSuchMethodException) throws NoSuchMethodException {
        Method foundMethod;
        try {
            foundMethod = classWithMethod.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?> superclass = classWithMethod.getSuperclass();
            if (superclass == null) {
                throw originalNoSuchMethodException;
            }
            NoSuchMethodException firstNoSuchMethodException = ReflectionUtils.getDefault(originalNoSuchMethodException, noSuchMethodException);
            foundMethod = ReflectionUtils.getMethod(methodName, superclass, argTypes, firstNoSuchMethodException);
        }
        return foundMethod;
    }

    private static <T> T getDefault(T mightBeNull, T useIfNull) {
        T result = mightBeNull == null ? useIfNull : mightBeNull;
        return result;
    }

    public static Object invokeMethod(final Method method, Object target, Object ... args) {
        try {
            if (!method.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        method.setAccessible(true);
                        return null;
                    }
                });
            }
            return method.invoke(target, args);
        }
        catch (Exception exception) {
            throw ExceptionUtils.asRuntimeException(exception);
        }
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static <TypeInThisClassLoader> TypeInThisClassLoader wrap(Object target, Class<TypeInThisClassLoader> interfaceClass) {
        Object result = interfaceClass.isAssignableFrom(target.getClass()) ? target : Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ProxyingInvocationHandler(target, interfaceClass));
        return (TypeInThisClassLoader)result;
    }
}

