/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.proxy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;

public class Proxy
implements Delayed,
Serializable {
    private static final long serialVersionUID = 228939737383625551L;
    public static final int ERROR_403 = 403;
    public static final int ERROR_404 = 404;
    public static final int ERROR_BANNED = 10000;
    public static final int ERROR_Proxy = 10001;
    public static final int SUCCESS = 200;
    private final HttpHost httpHost;
    private String user;
    private String password;
    private int reuseTimeInterval = 1500;
    private Long canReuseTime = 0L;
    private Long lastBorrowTime = System.currentTimeMillis();
    private Long responseTime = 0L;
    private int failedNum = 0;
    private int successNum = 0;
    private int borrowNum = 0;
    private List<Integer> failedErrorType = new ArrayList<Integer>();

    Proxy(HttpHost httpHost, String user, String password) {
        this.httpHost = httpHost;
        this.user = user;
        this.password = password;
        this.canReuseTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(this.reuseTimeInterval, TimeUnit.MILLISECONDS);
    }

    Proxy(HttpHost httpHost, int reuseInterval, String user, String password) {
        this.httpHost = httpHost;
        this.user = user;
        this.password = password;
        this.canReuseTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(reuseInterval, TimeUnit.MILLISECONDS);
    }

    public int getSuccessNum() {
        return this.successNum;
    }

    public void successNumIncrement(int increment) {
        this.successNum += increment;
    }

    public Long getLastUseTime() {
        return this.lastBorrowTime;
    }

    public void setLastBorrowTime(Long lastBorrowTime) {
        this.lastBorrowTime = lastBorrowTime;
    }

    public void recordResponse() {
        this.responseTime = (System.currentTimeMillis() - this.lastBorrowTime + this.responseTime) / 2L;
        this.lastBorrowTime = System.currentTimeMillis();
    }

    public List<Integer> getFailedErrorType() {
        return this.failedErrorType;
    }

    public void setFailedErrorType(List<Integer> failedErrorType) {
        this.failedErrorType = failedErrorType;
    }

    public void fail(int failedErrorType) {
        ++this.failedNum;
        this.failedErrorType.add(failedErrorType);
    }

    public void setFailedNum(int failedNum) {
        this.failedNum = failedNum;
    }

    public int getFailedNum() {
        return this.failedNum;
    }

    public String getFailedType() {
        String re = "";
        for (Integer i : this.failedErrorType) {
            re = re + i + " . ";
        }
        return re;
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    public int getReuseTimeInterval() {
        return this.reuseTimeInterval;
    }

    public void setReuseTimeInterval(int reuseTimeInterval) {
        this.reuseTimeInterval = reuseTimeInterval;
        this.canReuseTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(reuseTimeInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.canReuseTime - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        Proxy that = (Proxy)o;
        return this.canReuseTime > that.canReuseTime ? 1 : (this.canReuseTime < that.canReuseTime ? -1 : 0);
    }

    public String toString() {
        String re = String.format("host: %15s >> %5dms >> success: %-3.2f%% >> borrow: %d", this.httpHost.getAddress().getHostAddress(), this.responseTime, (double)this.successNum * 100.0 / (double)this.borrowNum, this.borrowNum);
        return re;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void borrowNumIncrement(int increment) {
        this.borrowNum += increment;
    }

    public int getBorrowNum() {
        return this.borrowNum;
    }
}

