/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.config;

import cn.hutool.core.io.FileUtil;
import cn.hutool.system.SystemUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final String CACHE_DIR = "smartjavaai_cache";
    private static String cachePath;

    public static void setCachePath(String customeCachePath) {
        if (!StringUtils.isNotBlank((CharSequence)customeCachePath)) {
            throw new IllegalArgumentException("\u7f13\u5b58\u8def\u5f84\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        cachePath = customeCachePath;
        FileUtil.mkdir((String)cachePath);
        System.setProperty("DJL_CACHE_DIR", cachePath);
    }

    public static String getCachePath() {
        if (StringUtils.isBlank((CharSequence)cachePath)) {
            Config.createCachePath();
        }
        if (StringUtils.isNotBlank((CharSequence)cachePath)) {
            System.setProperty("DJL_CACHE_DIR", cachePath);
        }
        return cachePath;
    }

    public static String getCachePathFromSystem() {
        return System.getProperty("DJL_CACHE_DIR");
    }

    private static void createCachePath() {
        String osName = SystemUtil.getOsInfo().getName();
        log.info("\u5f53\u524d\u64cd\u4f5c\u7cfb\u7edf\uff1a{}", (Object)osName);
        if (osName.toLowerCase().contains("windows")) {
            cachePath = SystemUtil.getUserInfo().getHomeDir() + CACHE_DIR;
            FileUtil.mkdir((String)cachePath);
        } else if (osName.toLowerCase().contains("linux")) {
            cachePath = "/root/smartjavaai_cache";
            FileUtil.mkdir((String)cachePath);
        } else if (osName.toLowerCase().contains("mac")) {
            cachePath = SystemUtil.getUserInfo().getHomeDir() + CACHE_DIR;
            FileUtil.mkdir((String)cachePath);
        } else {
            cachePath = SystemUtil.getUserInfo().getHomeDir() + CACHE_DIR;
            FileUtil.mkdir((String)cachePath);
        }
    }

    static {
        Config.createCachePath();
        if (StringUtils.isNotBlank((CharSequence)cachePath)) {
            System.setProperty("DJL_CACHE_DIR", cachePath);
        }
        System.setProperty("ai.djl.default_engine", "PyTorch");
        log.info("\u8bbe\u7f6e\u9ed8\u8ba4\u5f15\u64ce\uff1a{}", (Object)"PyTorch");
    }
}

