/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.config;

import cn.smartjavaai.common.enums.DeviceEnum;
import java.util.concurrent.ConcurrentHashMap;

public class ModelConfig {
    private DeviceEnum device;
    private int gpuId = 0;
    private String batchifier;
    private int predictorPoolSize;
    private ConcurrentHashMap<String, Object> customParams = new ConcurrentHashMap();

    public <T> T getCustomParam(String key, Class<T> clazz) {
        Object value = this.customParams.get(key);
        if (value == null) {
            return null;
        }
        return clazz.cast(value);
    }

    public void putCustomParam(String key, Object value) {
        if (this.customParams == null) {
            this.customParams = new ConcurrentHashMap();
        }
        this.customParams.put(key, value);
    }

    public DeviceEnum getDevice() {
        return this.device;
    }

    public int getGpuId() {
        return this.gpuId;
    }

    public String getBatchifier() {
        return this.batchifier;
    }

    public int getPredictorPoolSize() {
        return this.predictorPoolSize;
    }

    public ConcurrentHashMap<String, Object> getCustomParams() {
        return this.customParams;
    }

    public void setDevice(DeviceEnum device) {
        this.device = device;
    }

    public void setGpuId(int gpuId) {
        this.gpuId = gpuId;
    }

    public void setBatchifier(String batchifier) {
        this.batchifier = batchifier;
    }

    public void setPredictorPoolSize(int predictorPoolSize) {
        this.predictorPoolSize = predictorPoolSize;
    }

    public void setCustomParams(ConcurrentHashMap<String, Object> customParams) {
        this.customParams = customParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelConfig)) {
            return false;
        }
        ModelConfig other = (ModelConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeviceEnum this$device = this.getDevice();
        DeviceEnum other$device = other.getDevice();
        if (this$device == null ? other$device != null : !((Object)((Object)this$device)).equals((Object)other$device)) {
            return false;
        }
        if (this.getGpuId() != other.getGpuId()) {
            return false;
        }
        String this$batchifier = this.getBatchifier();
        String other$batchifier = other.getBatchifier();
        if (this$batchifier == null ? other$batchifier != null : !this$batchifier.equals(other$batchifier)) {
            return false;
        }
        if (this.getPredictorPoolSize() != other.getPredictorPoolSize()) {
            return false;
        }
        ConcurrentHashMap<String, Object> this$customParams = this.getCustomParams();
        ConcurrentHashMap<String, Object> other$customParams = other.getCustomParams();
        return !(this$customParams == null ? other$customParams != null : !((Object)this$customParams).equals(other$customParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeviceEnum $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)((Object)$device)).hashCode());
        result = result * 59 + this.getGpuId();
        String $batchifier = this.getBatchifier();
        result = result * 59 + ($batchifier == null ? 43 : $batchifier.hashCode());
        result = result * 59 + this.getPredictorPoolSize();
        ConcurrentHashMap<String, Object> $customParams = this.getCustomParams();
        result = result * 59 + ($customParams == null ? 43 : ((Object)$customParams).hashCode());
        return result;
    }

    public String toString() {
        return "ModelConfig(device=" + (Object)((Object)this.getDevice()) + ", gpuId=" + this.getGpuId() + ", batchifier=" + this.getBatchifier() + ", predictorPoolSize=" + this.getPredictorPoolSize() + ", customParams=" + this.getCustomParams() + ")";
    }
}

