/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.entity;

import java.util.Arrays;
import java.util.Optional;

public class R<T> {
    private Integer code;
    private String message;
    private T data;

    public static <T> R<T> ok() {
        R<T> r = new R<T>();
        r.code = 0;
        r.message = "\u6210\u529f";
        return r;
    }

    public static <T> R<T> ok(T data) {
        R<T> r = new R<T>();
        r.code = 0;
        r.message = "\u6210\u529f";
        r.data = data;
        return r;
    }

    public static <T> R<T> fail(Integer code, String message) {
        R<T> r = new R<T>();
        r.code = code;
        r.message = message;
        r.data = null;
        return r;
    }

    public static <T> R<T> fail(Status status) {
        R<T> r = new R<T>();
        r.code = status.code;
        r.message = status.message;
        r.data = null;
        return r;
    }

    public boolean isSuccess() {
        return this.code != null && this.code.equals(Status.SUCCESS.code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R other = (R)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof R;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public static enum Status {
        SUCCESS(0, "\u6210\u529f"),
        INVALID_IMAGE(1, "\u56fe\u50cf\u65e0\u6548"),
        FILE_NOT_FOUND(2, "\u6587\u4ef6\u4e0d\u5b58\u5728"),
        NO_FACE_DETECTED(3, "\u672a\u68c0\u6d4b\u5230\u4eba\u8138"),
        PARAM_ERROR(4, "\u53c2\u6570\u9519\u8bef"),
        INVALID_VIDEO(5, "\u89c6\u9891\u65e0\u6548"),
        NO_OBJECT_DETECTED(6, "\u672a\u68c0\u6d4b\u5230\u76ee\u6807"),
        Unknown(-1, "\u672a\u77e5\u9519\u8bef");

        private final int code;
        private final String message;

        private Status(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public static Status valueOf(int val) {
            Optional<Status> search = Arrays.stream(Status.values()).filter(status -> status.code == val).findFirst();
            return search.orElse(Unknown);
        }
    }
}

