/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.preprocess;

import cn.smartjavaai.common.entity.DetectionRectangle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class BufferedImagePreprocessor {
    private BufferedImage image;
    private DetectionRectangle rect;
    private float extendRatio = 1.0f;
    private int targetSize = 128;
    private int centerCropSize = 80;
    private Color paddingColor = new Color(127, 127, 127);
    private boolean enableSquarePadding = true;
    private boolean enableScaling = true;
    private boolean enableCenterCrop = false;

    public BufferedImagePreprocessor(BufferedImage image, DetectionRectangle rect) {
        this.image = image;
        this.rect = rect;
    }

    public BufferedImagePreprocessor setExtendRatio(float ratio) {
        this.extendRatio = ratio;
        return this;
    }

    public BufferedImagePreprocessor setTargetSize(int size) {
        this.targetSize = size;
        return this;
    }

    public BufferedImagePreprocessor setCenterCropSize(int size) {
        this.centerCropSize = size;
        return this;
    }

    public BufferedImagePreprocessor enableSquarePadding(boolean enable) {
        this.enableSquarePadding = enable;
        return this;
    }

    public BufferedImagePreprocessor enableScaling(boolean enable) {
        this.enableScaling = enable;
        return this;
    }

    public BufferedImagePreprocessor enableCenterCrop(boolean enable) {
        this.enableCenterCrop = enable;
        return this;
    }

    public BufferedImagePreprocessor setPaddingColor(Color color) {
        this.paddingColor = color;
        return this;
    }

    public BufferedImage process() {
        BufferedImage cropped = this.cropAndExtend();
        BufferedImage squared = this.enableSquarePadding ? this.squarePadding(cropped) : cropped;
        BufferedImage scaled = this.enableScaling ? this.scaleToTarget(squared) : squared;
        BufferedImage finalResult = this.enableCenterCrop ? this.centerCrop(scaled) : scaled;
        return finalResult;
    }

    private BufferedImage cropAndExtend() {
        int x = this.rect.x;
        int y = this.rect.y;
        int width = this.rect.width;
        int height = this.rect.height;
        int extendX = Math.round((float)width * this.extendRatio);
        int extendY = Math.round((float)height * this.extendRatio);
        int left = Math.max(0, x - extendX);
        int right = Math.min(this.image.getWidth(), x + width + extendX);
        int top = Math.max(0, y - extendY);
        int bottom = Math.min(this.image.getHeight(), y + height + extendY);
        int origRoiWidth = right - left;
        int origRoiHeight = bottom - top;
        int longSide = Math.max(origRoiWidth, origRoiHeight);
        int extendLeft = Math.min(left, (longSide - origRoiWidth) / 2);
        int extendRight = Math.min(this.image.getWidth() - right, (longSide - origRoiWidth + 1) / 2);
        int extendTop = Math.min(top, (longSide - origRoiHeight) / 2);
        int extendBottom = Math.min(this.image.getHeight() - bottom, (longSide - origRoiHeight + 1) / 2);
        int expandedLeft = left - extendLeft;
        int expandedRight = right + extendRight;
        int expandedTop = top - extendTop;
        int expandedBottom = bottom + extendBottom;
        int expandedWidth = expandedRight - expandedLeft;
        int expandedHeight = expandedBottom - expandedTop;
        return this.image.getSubimage(expandedLeft, expandedTop, expandedWidth, expandedHeight);
    }

    private BufferedImage squarePadding(BufferedImage src) {
        int longSide = Math.max(src.getWidth(), src.getHeight());
        BufferedImage squared = new BufferedImage(longSide, longSide, 5);
        Graphics2D g = squared.createGraphics();
        g.setColor(this.paddingColor);
        g.fillRect(0, 0, longSide, longSide);
        int xOffset = (longSide - src.getWidth()) / 2;
        int yOffset = (longSide - src.getHeight()) / 2;
        g.drawImage((Image)src, xOffset, yOffset, null);
        g.dispose();
        return squared;
    }

    private BufferedImage scaleToTarget(BufferedImage src) {
        Image scaled = src.getScaledInstance(this.targetSize, this.targetSize, 4);
        BufferedImage result = new BufferedImage(this.targetSize, this.targetSize, 5);
        Graphics2D g = result.createGraphics();
        g.drawImage(scaled, 0, 0, null);
        g.dispose();
        return result;
    }

    private BufferedImage centerCrop(BufferedImage src) {
        int startX = (src.getWidth() - this.centerCropSize) / 2;
        int startY = (src.getHeight() - this.centerCropSize) / 2;
        return src.getSubimage(startX, startY, this.centerCropSize, this.centerCropSize);
    }
}

