/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.utils;

import ai.djl.modality.cv.output.Point;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class PointUtils {
    public static List<Point> orderPoints(List<Point> points) {
        if (points == null || points.size() != 4) {
            throw new IllegalArgumentException("\u5fc5\u987b\u63d0\u4f9b 4 \u4e2a\u70b9");
        }
        points.sort(Comparator.comparingDouble(Point::getX));
        List<Point> left = points.subList(0, 2);
        List<Point> right = points.subList(2, 4);
        Point tl = left.get(0).getY() < left.get(1).getY() ? left.get(0) : left.get(1);
        Point bl = left.get(0).getY() >= left.get(1).getY() ? left.get(0) : left.get(1);
        Point tr = right.get(0).getY() < right.get(1).getY() ? right.get(0) : right.get(1);
        Point br = right.get(0).getY() >= right.get(1).getY() ? right.get(0) : right.get(1);
        return Arrays.asList(tl, tr, br, bl);
    }

    public static float distance(float[] point1, float[] point2) {
        float disX = point1[0] - point2[0];
        float disY = point1[1] - point2[1];
        float dis = (float)Math.sqrt(disX * disX + disY * disY);
        return dis;
    }

    public static float distance(Point point1, Point point2) {
        double disX = point1.getX() - point2.getX();
        double disY = point1.getY() - point2.getY();
        float dis = (float)Math.sqrt(disX * disX + disY * disY);
        return dis;
    }
}

