/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.ocr.config.TableStructureConfig;
import cn.smartjavaai.ocr.enums.TableStructureModelEnum;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.table.CommonTableStructureModel;
import cn.smartjavaai.ocr.model.table.TableStructureModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRecModelFactory {
    private static final Logger log = LoggerFactory.getLogger(TableRecModelFactory.class);
    private static volatile TableRecModelFactory instance;
    private static final ConcurrentHashMap<TableStructureModelEnum, TableStructureModel> tableStructureModelMap;
    private static final Map<TableStructureModelEnum, Class<? extends TableStructureModel>> tableStructureRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TableRecModelFactory getInstance() {
        if (instance != null) return instance;
        Class<TableRecModelFactory> clazz = TableRecModelFactory.class;
        synchronized (TableRecModelFactory.class) {
            if (instance != null) return instance;
            instance = new TableRecModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerTableStructureModel(TableStructureModelEnum tableStructureModelEnum, Class<? extends TableStructureModel> clazz) {
        tableStructureRegistry.put(tableStructureModelEnum, clazz);
    }

    public TableStructureModel getTableStructureModel(TableStructureConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new OcrException("\u672a\u914d\u7f6eOCR\u6a21\u578b");
        }
        return tableStructureModelMap.computeIfAbsent(config.getModelEnum(), k -> this.createTableStructureModel(config));
    }

    private TableStructureModel createTableStructureModel(TableStructureConfig config) {
        Class<? extends TableStructureModel> clazz = tableStructureRegistry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new OcrException("Unsupported model");
        }
        TableStructureModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OcrException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        tableStructureModelMap = new ConcurrentHashMap();
        tableStructureRegistry = new ConcurrentHashMap<TableStructureModelEnum, Class<? extends TableStructureModel>>();
        TableRecModelFactory.registerTableStructureModel(TableStructureModelEnum.SLANET, CommonTableStructureModel.class);
        TableRecModelFactory.registerTableStructureModel(TableStructureModelEnum.SLANET_PLUS, CommonTableStructureModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

