/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.common.detect.criteria;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.ndarray.NDList;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.ocr.config.OcrDetModelConfig;
import cn.smartjavaai.ocr.enums.CommonDetModelEnum;
import cn.smartjavaai.ocr.model.common.detect.translator.PPOCRDetTranslator;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class OcrCommonDetCriterialFactory {
    public static Criteria<Image, NDList> createCriteria(OcrDetModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Criteria criteria = null;
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.putAll(config.getCustomParams());
        if (StringUtils.isNotBlank((CharSequence)config.getBatchifier())) {
            params.put("batchifier", config.getBatchifier());
        }
        if (config.getModelEnum() == CommonDetModelEnum.PP_OCR_V5_SERVER_DET_MODEL || config.getModelEnum() == CommonDetModelEnum.PP_OCR_V5_MOBILE_DET_MODEL || config.getModelEnum() == CommonDetModelEnum.PP_OCR_V4_SERVER_DET_MODEL || config.getModelEnum() == CommonDetModelEnum.PP_OCR_V4_MOBILE_DET_MODEL) {
            criteria = Criteria.builder().optEngine("OnnxRuntime").setTypes(Image.class, NDList.class).optModelPath(Paths.get(config.getDetModelPath(), new String[0])).optTranslator((Translator)new PPOCRDetTranslator(params)).optDevice(device).optProgress((Progress)new ProgressBar()).build();
        }
        return criteria;
    }
}

