/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.plate;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.Base64ImageUtils;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.ocr.config.PlateRecModelConfig;
import cn.smartjavaai.ocr.entity.PlateInfo;
import cn.smartjavaai.ocr.entity.PlateResult;
import cn.smartjavaai.ocr.enums.PlateType;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.plate.PlateRecModel;
import cn.smartjavaai.ocr.model.plate.criteria.PlateRecCriterialFactory;
import cn.smartjavaai.ocr.utils.OcrUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRNNPlateRecModel
implements PlateRecModel {
    private static final Logger log = LoggerFactory.getLogger(CRNNPlateRecModel.class);
    private GenericObjectPool<Predictor<Image, PlateResult>> recPredictorPool;
    private ZooModel<Image, PlateResult> recModel;
    private PlateRecModelConfig config;

    @Override
    public void loadModel(PlateRecModelConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new OcrException("modelPath is null");
        }
        this.config = config;
        Criteria<Image, PlateResult> detCriteria = PlateRecCriterialFactory.createCriteria(config);
        try {
            this.recModel = ModelZoo.loadModel(detCriteria);
            this.recPredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.recModel));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.recPredictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.recModel.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new OcrException("\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public R<List<PlateInfo>> recognize(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image img = null;
        try {
            R<List<PlateInfo>> plateResult;
            img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            R<List<PlateInfo>> r = plateResult = this.recognize(img);
            return r;
        }
        catch (IOException e) {
            throw new OcrException("\u65e0\u6548\u7684\u56fe\u7247", e);
        }
        finally {
            ((Mat)img.getWrappedImage()).release();
        }
    }

    @Override
    public R<List<PlateInfo>> recognizeBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.recognize(imageData);
    }

    @Override
    public R<List<PlateInfo>> recognize(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
        R<List<PlateInfo>> plateResult = this.recognize(img);
        ((Mat)img.getWrappedImage()).release();
        return plateResult;
    }

    @Override
    public R<List<PlateInfo>> recognize(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        return this.recognize(new ByteArrayInputStream(imageData));
    }

    @Override
    public R<List<PlateInfo>> recognize(Image image) {
        if (Objects.isNull(this.config.getPlateDetModel())) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"\u672a\u6307\u5b9a\u8f66\u724c\u68c0\u6d4b\u6a21\u578b");
        }
        DetectedObjects detectedObjects = this.config.getPlateDetModel().detect(image);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
        }
        List<PlateInfo> plateInfoList = OcrUtils.convertToPlateInfo(detectedObjects, image);
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.recPredictorPool.borrowObject();
            for (PlateInfo plateInfo : plateInfoList) {
                PlateResult plateResult;
                DetectionRectangle detectionRectangle = plateInfo.getDetectionRectangle();
                Image subImage = OcrUtils.transformAndCrop((Mat)image.getWrappedImage(), plateInfo.getBox());
                if (plateInfo.getPlateType() == PlateType.DOUBLE) {
                    Mat mergeImage = this.getSplitMerge((Mat)subImage.getWrappedImage());
                    subImage = ImageFactory.getInstance().fromImage((Object)mergeImage);
                }
                if (!Objects.nonNull(plateResult = (PlateResult)predictor.predict((Object)subImage))) continue;
                plateInfo.setPlateNumber(plateResult.getPlateNo());
                plateInfo.setPlateColor(plateResult.getPlateColor());
            }
            R r = R.ok(plateInfoList);
            return r;
        }
        catch (Exception e) {
            throw new OcrException("\u8f66\u724c\u8bc6\u522b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.recPredictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    private Mat getSplitMerge(Mat img) {
        int h = img.rows();
        int w = img.cols();
        Rect upperRect = new Rect(0, 0, w, (int)(0.4166666666666667 * (double)h));
        Mat imgUpper = new Mat(img, upperRect);
        Rect lowerRect = new Rect(0, (int)(0.3333333333333333 * (double)h), w, h - (int)(0.3333333333333333 * (double)h));
        Mat imgLower = new Mat(img, lowerRect);
        Mat resizedUpper = new Mat();
        Size lowerSize = imgLower.size();
        Imgproc.resize((Mat)imgUpper, (Mat)resizedUpper, (Size)lowerSize);
        ArrayList<Mat> mergeList = new ArrayList<Mat>();
        mergeList.add(resizedUpper);
        mergeList.add(imgLower);
        Mat merged = new Mat();
        Core.hconcat(mergeList, (Mat)merged);
        return merged;
    }

    @Override
    public PlateResult recognizeCropped(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.recPredictorPool.borrowObject();
            PlateResult plateResult = (PlateResult)predictor.predict((Object)image);
            return plateResult;
        }
        catch (Exception e) {
            throw new OcrException("\u8f66\u724c\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.recPredictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public R<List<PlateInfo>> recognize(InputStream inputStream) {
        if (Objects.isNull(inputStream)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = null;
        try {
            img = ImageFactory.getInstance().fromInputStream(inputStream);
            R<List<PlateInfo>> r = this.recognize(img);
            return r;
        }
        catch (IOException e) {
            throw new OcrException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        finally {
            if (img != null) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<Void> recognizeAndDraw(String imagePath, String outputPath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image img = null;
        try {
            img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            R<List<PlateInfo>> plateResult = this.recognize(img);
            if (!plateResult.isSuccess()) {
                R r = R.fail((Integer)plateResult.getCode(), (String)plateResult.getMessage());
                return r;
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)plateResult.getData()))) {
                R r = R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
                return r;
            }
            BufferedImage bufferedImage = OpenCVUtils.mat2Image((Mat)((Mat)img.getWrappedImage()));
            OcrUtils.drawPlateInfo(bufferedImage, (List<PlateInfo>)((List)plateResult.getData()));
            ImageIO.write((RenderedImage)bufferedImage, "jpg", new File(outputPath));
            R r = R.ok();
            return r;
        }
        catch (IOException e) {
            throw new OcrException(e);
        }
        finally {
            if (img != null) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<BufferedImage> recognizeAndDraw(BufferedImage sourceImage) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)sourceImage));
        try {
            R<List<PlateInfo>> plateResult = this.recognize(img);
            if (!plateResult.isSuccess()) {
                R r = R.fail((Integer)plateResult.getCode(), (String)plateResult.getMessage());
                return r;
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)plateResult.getData()))) {
                R r = R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
                return r;
            }
            OcrUtils.drawPlateInfo((Mat)img.getWrappedImage(), (List<PlateInfo>)((List)plateResult.getData()));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)outputStream, "png");
            byte[] imageBytes = outputStream.toByteArray();
            R r = R.ok((Object)ImageIO.read(new ByteArrayInputStream(imageBytes)));
            return r;
        }
        catch (IOException e) {
            throw new OcrException("\u5bfc\u51fa\u56fe\u7247\u5931\u8d25", e);
        }
        finally {
            if (img != null) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public GenericObjectPool<Predictor<Image, PlateResult>> getPool() {
        return this.recPredictorPool;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.recPredictorPool != null) {
                this.recPredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.recModel != null) {
                this.recModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

