/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.utils;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.opencv.OpenCVImageFactory;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.common.utils.PointUtils;
import cn.smartjavaai.ocr.entity.OcrBox;
import cn.smartjavaai.ocr.entity.OcrInfo;
import cn.smartjavaai.ocr.entity.OcrItem;
import cn.smartjavaai.ocr.entity.PlateInfo;
import cn.smartjavaai.ocr.entity.RotatedBox;
import cn.smartjavaai.ocr.entity.RotatedBoxCompX;
import cn.smartjavaai.ocr.enums.AngleEnum;
import cn.smartjavaai.ocr.enums.PlateType;
import cn.smartjavaai.ocr.opencv.OcrNDArrayUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrUtils {
    private static final Logger log = LoggerFactory.getLogger(OcrUtils.class);

    public static List<OcrBox> convertToOcrBox(NDList dt_boxes) {
        ArrayList<OcrBox> boxList = new ArrayList<OcrBox>();
        for (NDArray box : dt_boxes) {
            float[] pointsArr = box.toFloatArray();
            OcrBox ocrBox = new OcrBox(new Point((double)pointsArr[0], (double)pointsArr[1]), new Point((double)pointsArr[2], (double)pointsArr[3]), new Point((double)pointsArr[4], (double)pointsArr[5]), new Point((double)pointsArr[6], (double)pointsArr[7]));
            boxList.add(ocrBox);
        }
        return boxList;
    }

    public static List<List<OcrBox>> convertToOcrBox(List<NDList> ndLists) {
        if (ndLists == null || ndLists.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<OcrBox>> boxLists = new ArrayList<List<OcrBox>>();
        for (NDList dt_boxes : ndLists) {
            boxLists.add(OcrUtils.convertToOcrBox(dt_boxes));
        }
        return boxLists;
    }

    public static Image rotateImg(NDManager manager, Image image) {
        NDArray rotated = NDImageUtils.rotate90((NDArray)image.toNDArray(manager), (int)1);
        return ImageFactory.getInstance().fromNDArray(rotated);
    }

    public static Image rotateImg(Image image, int times) {
        try (NDManager manager = NDManager.newBaseManager();){
            NDArray rotated = NDImageUtils.rotate90((NDArray)image.toNDArray(manager), (int)times);
            Image image2 = OpenCVImageFactory.getInstance().fromNDArray(rotated);
            return image2;
        }
    }

    public static Image rotateImg(Image image, AngleEnum angleEnum) {
        try (NDManager manager = NDManager.newBaseManager();){
            int times = 0;
            switch (angleEnum) {
                case ANGLE_90: {
                    times = 1;
                    break;
                }
                case ANGLE_180: {
                    times = 2;
                    break;
                }
                case ANGLE_270: {
                    times = 3;
                }
            }
            NDArray rotated = NDImageUtils.rotate90((NDArray)image.toNDArray(manager), (int)times);
            Image image2 = OpenCVImageFactory.getInstance().fromNDArray(rotated);
            return image2;
        }
    }

    public static OcrInfo convertToOcrInfo(List<ArrayList<RotatedBoxCompX>> lines) {
        if (Objects.isNull(lines) || lines.size() == 0) {
            return null;
        }
        ArrayList<List<OcrItem>> lineList = new ArrayList<List<OcrItem>>();
        String fullText = "";
        for (ArrayList<RotatedBoxCompX> boxList : lines) {
            ArrayList<OcrItem> line = new ArrayList<OcrItem>();
            for (RotatedBoxCompX box : boxList) {
                float[] pointsArr = box.getBox().toFloatArray();
                float[] lt = Arrays.copyOfRange(pointsArr, 0, 2);
                float[] rt = Arrays.copyOfRange(pointsArr, 2, 4);
                float[] rb = Arrays.copyOfRange(pointsArr, 4, 6);
                float[] lb = Arrays.copyOfRange(pointsArr, 6, 8);
                OcrBox ocrBox = new OcrBox(new Point((double)lt[0], (double)lt[1]), new Point((double)rt[0], (double)rt[1]), new Point((double)rb[0], (double)rb[1]), new Point((double)lb[0], (double)lb[1]));
                OcrItem ocrItem = new OcrItem(ocrBox, box.getText());
                line.add(ocrItem);
                String text = box.getText();
                if (text.trim().equals("")) continue;
                fullText = fullText + text + " ";
            }
            lineList.add(line);
            fullText = fullText + '\n';
        }
        return new OcrInfo(lineList, fullText);
    }

    public static OcrInfo convertRotatedBoxesToOcrItems(List<RotatedBox> rotatedBoxes) {
        OcrInfo ocrInfo = new OcrInfo();
        ArrayList<OcrItem> ocrItems = new ArrayList<OcrItem>();
        StringBuilder fullText = new StringBuilder();
        for (RotatedBox rotatedBox : rotatedBoxes) {
            NDArray box = rotatedBox.getBox();
            float[] points = box.toFloatArray();
            Point topLeft = new Point((double)points[0], (double)points[1]);
            Point topRight = new Point((double)points[2], (double)points[3]);
            Point bottomRight = new Point((double)points[4], (double)points[5]);
            Point bottomLeft = new Point((double)points[6], (double)points[7]);
            OcrBox ocrBox = new OcrBox(topLeft, topRight, bottomRight, bottomLeft);
            String text = rotatedBox.getText();
            OcrItem item = new OcrItem();
            item.setOcrBox(ocrBox);
            item.setText(text);
            ocrItems.add(item);
            fullText.append(text + " ");
        }
        if (fullText.length() > 0) {
            fullText.deleteCharAt(fullText.length() - 1);
        }
        ocrInfo.setOcrItemList(ocrItems);
        ocrInfo.setFullText(fullText.toString());
        return ocrInfo;
    }

    public static Image transformAndCrop(Mat srcMat, List<ai.djl.modality.cv.output.Point> landMarks) {
        if (landMarks == null || landMarks.size() != 4) {
            throw new IllegalArgumentException("\u5fc5\u987b\u63d0\u4f9b4\u4e2a\u5173\u952e\u70b9");
        }
        List ordered = PointUtils.orderPoints(landMarks);
        ai.djl.modality.cv.output.Point lt = (ai.djl.modality.cv.output.Point)ordered.get(0);
        ai.djl.modality.cv.output.Point rt = (ai.djl.modality.cv.output.Point)ordered.get(1);
        ai.djl.modality.cv.output.Point rb = (ai.djl.modality.cv.output.Point)ordered.get(2);
        ai.djl.modality.cv.output.Point lb = (ai.djl.modality.cv.output.Point)ordered.get(3);
        int img_crop_width = (int)Math.max(PointUtils.distance((ai.djl.modality.cv.output.Point)lt, (ai.djl.modality.cv.output.Point)rt), PointUtils.distance((ai.djl.modality.cv.output.Point)rb, (ai.djl.modality.cv.output.Point)lb));
        int img_crop_height = (int)Math.max(PointUtils.distance((ai.djl.modality.cv.output.Point)lt, (ai.djl.modality.cv.output.Point)lb), PointUtils.distance((ai.djl.modality.cv.output.Point)rt, (ai.djl.modality.cv.output.Point)rb));
        List<ai.djl.modality.cv.output.Point> dstPoints = Arrays.asList(new ai.djl.modality.cv.output.Point(0.0, 0.0), new ai.djl.modality.cv.output.Point((double)img_crop_width, 0.0), new ai.djl.modality.cv.output.Point((double)img_crop_width, (double)img_crop_height), new ai.djl.modality.cv.output.Point(0.0, (double)img_crop_height));
        Mat srcPoint2f = OcrNDArrayUtils.toMat(ordered);
        Mat dstPoint2f = OcrNDArrayUtils.toMat(dstPoints);
        Mat cvMat = OpenCVUtils.perspectiveTransform((Mat)srcMat, (Mat)srcPoint2f, (Mat)dstPoint2f);
        Image subImg = OpenCVImageFactory.getInstance().fromImage((Object)cvMat);
        subImg = subImg.getSubImage(0, 0, img_crop_width, img_crop_height);
        cvMat.release();
        srcPoint2f.release();
        dstPoint2f.release();
        return subImg;
    }

    public static Image transformAndCrop(Mat srcMat, OcrBox box) {
        float[] pointsArr = box.toFloatArray();
        float[] lt = Arrays.copyOfRange(pointsArr, 0, 2);
        float[] rt = Arrays.copyOfRange(pointsArr, 2, 4);
        float[] rb = Arrays.copyOfRange(pointsArr, 4, 6);
        float[] lb = Arrays.copyOfRange(pointsArr, 6, 8);
        int img_crop_width = (int)Math.max(PointUtils.distance((float[])lt, (float[])rt), PointUtils.distance((float[])rb, (float[])lb));
        int img_crop_height = (int)Math.max(PointUtils.distance((float[])lt, (float[])lb), PointUtils.distance((float[])rt, (float[])rb));
        ArrayList<ai.djl.modality.cv.output.Point> srcPoints = new ArrayList<ai.djl.modality.cv.output.Point>();
        srcPoints.add(new ai.djl.modality.cv.output.Point((double)lt[0], (double)lt[1]));
        srcPoints.add(new ai.djl.modality.cv.output.Point((double)rt[0], (double)rt[1]));
        srcPoints.add(new ai.djl.modality.cv.output.Point((double)rb[0], (double)rb[1]));
        srcPoints.add(new ai.djl.modality.cv.output.Point((double)lb[0], (double)lb[1]));
        ArrayList<ai.djl.modality.cv.output.Point> dstPoints = new ArrayList<ai.djl.modality.cv.output.Point>();
        dstPoints.add(new ai.djl.modality.cv.output.Point(0.0, 0.0));
        dstPoints.add(new ai.djl.modality.cv.output.Point((double)img_crop_width, 0.0));
        dstPoints.add(new ai.djl.modality.cv.output.Point((double)img_crop_width, (double)img_crop_height));
        dstPoints.add(new ai.djl.modality.cv.output.Point(0.0, (double)img_crop_height));
        Mat srcPoint2f = OcrNDArrayUtils.toMat(srcPoints);
        Mat dstPoint2f = OcrNDArrayUtils.toMat(dstPoints);
        Mat cvMat = OpenCVUtils.perspectiveTransform((Mat)srcMat, (Mat)srcPoint2f, (Mat)dstPoint2f);
        Image subImg = OpenCVImageFactory.getInstance().fromImage((Object)cvMat);
        subImg = subImg.getSubImage(0, 0, img_crop_width, img_crop_height);
        cvMat.release();
        srcPoint2f.release();
        dstPoint2f.release();
        return subImg;
    }

    public static void drawRect(Mat mat, List<OcrBox> boxList) {
        for (OcrBox ocrBox : boxList) {
            Imgproc.line((Mat)mat, (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (org.opencv.core.Point)ocrBox.getTopRight().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)mat, (org.opencv.core.Point)ocrBox.getTopRight().toCvPoint(), (org.opencv.core.Point)ocrBox.getBottomRight().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)mat, (org.opencv.core.Point)ocrBox.getBottomRight().toCvPoint(), (org.opencv.core.Point)ocrBox.getBottomLeft().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)mat, (org.opencv.core.Point)ocrBox.getBottomLeft().toCvPoint(), (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectWithText(BufferedImage image, OcrInfo ocrInfo, int fontSize) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        try {
            Font font = new Font("\u6977\u4f53", 0, fontSize);
            g.setFont(font);
            g.setColor(new Color(0, 0, 255));
            BasicStroke bStroke = new BasicStroke(2.0f, 0, 0);
            g.setStroke(bStroke);
            List<OcrItem> ocrItemList = ocrInfo.getOcrItemList();
            if (CollectionUtils.isNotEmpty(ocrInfo.getLineList())) {
                ocrItemList = ocrInfo.flattenLines();
            }
            for (OcrItem item : ocrItemList) {
                OcrBox box = item.getOcrBox();
                int[] xPoints = new int[]{(int)box.getTopLeft().getX(), (int)box.getTopRight().getX(), (int)box.getBottomRight().getX(), (int)box.getBottomLeft().getX(), (int)box.getTopLeft().getX()};
                int[] yPoints = new int[]{(int)box.getTopLeft().getY(), (int)box.getTopRight().getY(), (int)box.getBottomRight().getY(), (int)box.getBottomLeft().getY(), (int)box.getTopLeft().getY()};
                g.drawPolyline(xPoints, yPoints, 5);
                g.drawString(item.getText(), xPoints[0], yPoints[0]);
            }
        }
        finally {
            g.dispose();
        }
    }

    public static void drawRectWithText(Mat srcMat, List<OcrItem> itemList) {
        for (OcrItem item : itemList) {
            OcrBox ocrBox = item.getOcrBox();
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (org.opencv.core.Point)ocrBox.getTopRight().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getTopRight().toCvPoint(), (org.opencv.core.Point)ocrBox.getBottomRight().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getBottomRight().toCvPoint(), (org.opencv.core.Point)ocrBox.getBottomLeft().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getBottomLeft().toCvPoint(), (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.putText((Mat)srcMat, (String)item.getAngle().getValue(), (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (int)6, (double)1.0, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
        }
    }

    public static List<PlateInfo> convertToPlateInfo(DetectedObjects detectedObjects, Image image) {
        ArrayList<PlateInfo> plateInfoList = new ArrayList<PlateInfo>();
        Iterator iterator = detectedObjects.items().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            DetectedObjects.DetectedObject result = (DetectedObjects.DetectedObject)iterator.next();
            BoundingBox box = result.getBoundingBox();
            ArrayList keyPoints = new ArrayList();
            box.getBounds().getPath().forEach(point -> keyPoints.add(new Point(point.getX(), point.getY())));
            int x = (int)(box.getBounds().getX() * (double)image.getWidth());
            int y = (int)(box.getBounds().getY() * (double)image.getHeight());
            int width = (int)(box.getBounds().getWidth() * (double)image.getWidth());
            int height = (int)(box.getBounds().getHeight() * (double)image.getHeight());
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x + width > image.getWidth()) {
                width = image.getWidth() - x;
            }
            if (y + height > image.getHeight()) {
                height = image.getHeight() - y;
            }
            PlateInfo plateInfo = new PlateInfo();
            plateInfo.setPlateType(PlateType.fromClassName((String)detectedObjects.getClassNames().get(index)));
            plateInfo.setScore(((Double)detectedObjects.getProbabilities().get(index)).floatValue());
            plateInfo.setDetectionRectangle(new DetectionRectangle(x, y, width, height));
            OcrBox ocrBox = new OcrBox((Point)keyPoints.get(0), (Point)keyPoints.get(1), (Point)keyPoints.get(2), (Point)keyPoints.get(3));
            plateInfo.setBox(ocrBox);
            plateInfoList.add(plateInfo);
            ++index;
        }
        return plateInfoList;
    }

    public static void drawPlateInfo(Mat srcMat, List<PlateInfo> plateInfoList) {
        for (PlateInfo plateInfo : plateInfoList) {
            OcrBox ocrBox = plateInfo.getBox();
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (org.opencv.core.Point)ocrBox.getTopRight().toCvPoint(), (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getTopRight().toCvPoint(), (org.opencv.core.Point)ocrBox.getBottomRight().toCvPoint(), (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getBottomRight().toCvPoint(), (org.opencv.core.Point)ocrBox.getBottomLeft().toCvPoint(), (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
            Imgproc.line((Mat)srcMat, (org.opencv.core.Point)ocrBox.getBottomLeft().toCvPoint(), (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
            ImageUtils.putTextWithBackground((Mat)srcMat, (String)(plateInfo.getPlateNumber() + " " + plateInfo.getPlateColor()), (org.opencv.core.Point)ocrBox.getTopLeft().toCvPoint(), (Scalar)new Scalar(255.0, 255.0, 255.0), (Scalar)new Scalar(0.0, 0.0, 0.0), (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawPlateInfo(BufferedImage image, List<PlateInfo> plateInfoList) {
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        try {
            graphics.setColor(Color.RED);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int stroke = 2;
            for (PlateInfo plateInfo : plateInfoList) {
                DetectionRectangle rectangle = plateInfo.getDetectionRectangle();
                graphics.setColor(Color.RED);
                graphics.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
                graphics.setColor(Color.BLACK);
                ImageUtils.drawText((Graphics2D)graphics, (String)(plateInfo.getPlateNumber() + " " + plateInfo.getPlateColor()), (int)rectangle.getX(), (int)rectangle.getY(), (int)stroke, (int)4);
                OcrBox ocrBox = plateInfo.getBox();
                graphics.setColor(Color.BLUE);
                graphics.drawRect((int)ocrBox.getTopLeft().getX(), (int)ocrBox.getTopLeft().getY(), 2, 2);
                graphics.setColor(Color.GREEN);
                graphics.drawRect((int)ocrBox.getTopRight().getX(), (int)ocrBox.getTopRight().getY(), 2, 2);
                graphics.setColor(Color.RED);
                graphics.drawRect((int)ocrBox.getBottomLeft().getX(), (int)ocrBox.getBottomLeft().getY(), 2, 2);
                graphics.setColor(Color.CYAN);
                graphics.drawRect((int)ocrBox.getBottomRight().getX(), (int)ocrBox.getBottomRight().getY(), 2, 2);
            }
        }
        finally {
            graphics.dispose();
        }
    }
}

