/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.job.core.enums.AllocationAlgorithmEnum;
import com.aizuda.snailjob.client.job.core.enums.TriggerTypeEnum;
import com.aizuda.snailjob.client.job.core.handler.AbstractJobRequestHandler;
import com.aizuda.snailjob.client.job.core.util.TriggerIntervalUtils;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.ExecutorTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobArgsTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobBlockStrategyEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.JobApiRequest;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public abstract class AbstractParamsHandler<H, R>
extends AbstractJobRequestHandler<R> {
    protected static final String SHARD_NUM = "shardNum";
    private final JobApiRequest reqDTO = new JobApiRequest();
    private H r;

    public AbstractParamsHandler(JobTaskTypeEnum taskType) {
        this.reqDTO.setTaskType(Integer.valueOf(taskType.getType()));
        this.reqDTO.setExecutorType(Integer.valueOf(ExecutorTypeEnum.JAVA.getType()));
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        this.reqDTO.setGroupName(snailJobProperties.getGroup());
        this.reqDTO.setJobStatus(StatusEnum.YES.getStatus());
    }

    protected H setId(Long id) {
        this.reqDTO.setId(id);
        return this.r;
    }

    private H setArgsStr(Map<String, Object> argsStr) {
        Map<String, Object> args = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)this.reqDTO.getArgsStr())) {
            args = JsonUtil.parseHashMap((String)this.reqDTO.getArgsStr());
        }
        args.putAll(argsStr);
        this.reqDTO.setArgsStr(JsonUtil.toJsonString(args));
        this.reqDTO.setArgsType(JobArgsTypeEnum.JSON.getArgsType());
        return this.r;
    }

    protected H setShardNum(Integer shardNum) {
        if (shardNum != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put(SHARD_NUM, shardNum);
            this.setArgsStr(map);
        }
        return this.r;
    }

    public H setJobStatus(StatusEnum statusEnum) {
        this.reqDTO.setJobStatus(statusEnum.getStatus());
        return this.r;
    }

    public H setJobName(String jobName) {
        this.reqDTO.setJobName(jobName);
        return this.r;
    }

    protected H addArgsStr(String argsKey, Object argsValue) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)this.reqDTO.getArgsStr())) {
            map = JsonUtil.parseHashMap((String)this.reqDTO.getArgsStr());
        }
        map.put(argsKey, argsValue);
        this.reqDTO.setArgsStr(JsonUtil.toJsonString(map));
        this.reqDTO.setArgsType(JobArgsTypeEnum.JSON.getArgsType());
        return this.r;
    }

    protected H addShardingArgs(String ... shardingValue) {
        this.reqDTO.setArgsStr(JsonUtil.toJsonString((Object)shardingValue));
        this.reqDTO.setArgsType(JobArgsTypeEnum.TEXT.getArgsType());
        return this.r;
    }

    protected H setRouteKey(AllocationAlgorithmEnum algorithmEnum) {
        this.reqDTO.setRouteKey(Integer.valueOf(algorithmEnum.getType()));
        return this.r;
    }

    public H setExecutorInfo(String executorInfo) {
        this.reqDTO.setExecutorInfo(executorInfo);
        return this.r;
    }

    public H setTriggerType(TriggerTypeEnum triggerType) {
        this.reqDTO.setTriggerType(Integer.valueOf(triggerType.getType()));
        return this.r;
    }

    public H setTriggerInterval(Integer triggerInterval) {
        Assert.isTrue((this.reqDTO.getTriggerType().intValue() == TriggerTypeEnum.SCHEDULED_TIME.getType() ? 1 : 0) != 0, () -> new SnailJobClientException("This method is only limited to fixed time usage"));
        Assert.isFalse((this.reqDTO.getTriggerType().intValue() == TriggerTypeEnum.POINT_IN_TIME.getType() ? 1 : 0) != 0, () -> new SnailJobClientException("This configuration is not available for delay tasks"));
        this.setTriggerInterval(String.valueOf(triggerInterval));
        return this.r;
    }

    public H setTriggerTime(Set<LocalDateTime> triggerTime) {
        Assert.isTrue((this.reqDTO.getTriggerType().intValue() == TriggerTypeEnum.POINT_IN_TIME.getType() ? 1 : 0) != 0, () -> new SnailJobClientException("This method can only be used for delay tasks"));
        String parseJson = TriggerIntervalUtils.checkTriggerTimeAndParseJson(triggerTime);
        this.setTriggerInterval(parseJson);
        return this.r;
    }

    public H setTriggerInterval(String triggerInterval) {
        Assert.isFalse((this.reqDTO.getTriggerType().intValue() == TriggerTypeEnum.WORK_FLOW.getType() ? 1 : 0) != 0, () -> new SnailJobClientException("No need to configure workflow"));
        this.reqDTO.setTriggerInterval(triggerInterval);
        return this.r;
    }

    public H setBlockStrategy(JobBlockStrategyEnum blockStrategy) {
        this.reqDTO.setBlockStrategy(Integer.valueOf(blockStrategy.getBlockStrategy()));
        return this.r;
    }

    public H setExecutorTimeout(Integer executorTimeout) {
        this.reqDTO.setExecutorTimeout(executorTimeout);
        return this.r;
    }

    public H setMaxRetryTimes(Integer maxRetryTimes) {
        this.reqDTO.setMaxRetryTimes(maxRetryTimes);
        return this.r;
    }

    public H setRetryInterval(Integer retryInterval) {
        this.reqDTO.setRetryInterval(retryInterval);
        return this.r;
    }

    protected H setParallelNum(Integer parallelNum) {
        this.reqDTO.setParallelNum(parallelNum);
        return this.r;
    }

    public H setDescription(String description) {
        this.reqDTO.setDescription(description);
        return this.r;
    }

    public H setLabels(Map<String, String> labels) {
        if (labels == null) {
            return this.r;
        }
        if (labels.containsKey("state")) {
            throw new SnailJobClientException("Label key cannot be 'state'");
        }
        this.reqDTO.setLabels(JsonUtil.toJsonString(labels));
        return this.r;
    }

    @Generated
    public JobApiRequest getReqDTO() {
        return this.reqDTO;
    }

    @Generated
    public void setR(H r) {
        this.r = r;
    }
}

