/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.server.handler;

import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.UpdateClientInfoDTO;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class UpdateClientInfoHttpRequestHandler
extends PostHttpRequestHandler {
    private final InstanceManager instanceManager;

    @Override
    public boolean supports(String path) {
        return "/update/client/info/v1".equals(path);
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.POST;
    }

    @Override
    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.info("Client Update Request. content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        UpdateClientInfoDTO clientInfoDTO = (UpdateClientInfoDTO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), UpdateClientInfoDTO.class);
        try {
            Boolean updated = this.instanceManager.updateInstanceLabels(clientInfoDTO);
            SnailJobLog.LOCAL.info("Client Update Request. content:[{}]", new Object[]{content});
            return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), "success", (Object)updated, retryRequest.getReqId());
        }
        catch (Exception e) {
            return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), e.getMessage(), (Object)Boolean.FALSE, retryRequest.getReqId());
        }
    }

    @Generated
    public UpdateClientInfoHttpRequestHandler(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

