/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.service.impl;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.model.request.RetryArgsDeserializeRequest;
import com.aizuda.snailjob.model.request.base.StatusUpdateRequest;
import com.aizuda.snailjob.model.request.base.TriggerRetryRequest;
import com.aizuda.snailjob.model.response.base.RetryResponse;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.enums.RetryTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskPrepareDTO;
import com.aizuda.snailjob.server.service.convert.RetryConverter;
import com.aizuda.snailjob.server.service.handler.RetryArgsDeserializeHandler;
import com.aizuda.snailjob.server.service.service.RetryService;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDateTime;
import java.util.Objects;
import org.apache.pekko.actor.ActorRef;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRetryService
implements RetryService {
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    private RetryArgsDeserializeHandler retryArgsDeserializeHandler;

    @Override
    public <T extends RetryResponse> T getRetryById(Long retryId, Class<T> clazz) {
        RetryResponse instance;
        Retry retry = (Retry)this.accessTemplate.getRetryAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getId, (Object)retryId));
        Assert.notNull((Object)retry, () -> new SnailJobServerException("Retry task not found:[{}].", new Object[]{retryId}));
        try {
            instance = (RetryResponse)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            RetryConverter.INSTANCE.toRetryResponseVO(retry, instance);
            RetryArgsDeserializeRequest deserializeDTO = new RetryArgsDeserializeRequest();
            deserializeDTO.setArgsStr(retry.getArgsStr());
            deserializeDTO.setExecutorName(retry.getExecutorName());
            deserializeDTO.setScene(retry.getSceneName());
            deserializeDTO.setGroup(retry.getGroupName());
            deserializeDTO.setSerializerName(retry.getSerializerName());
            deserializeDTO.setNamespaceId(retry.getNamespaceId());
            instance.setArgsStr(this.retryArgsDeserializeHandler.deserialize(deserializeDTO));
        }
        catch (Exception e) {
            throw new SnailJobServerException("Failed to get retry by id [{}]", new Object[]{retryId, e});
        }
        return (T)instance;
    }

    @Override
    public boolean triggerRetry(TriggerRetryRequest triggerRetryRequest) {
        Retry retry = (Retry)this.accessTemplate.getRetryAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getId, (Object)triggerRetryRequest.getId()));
        Assert.notNull((Object)retry, () -> new SnailJobServerException("Retry task not found:[{}].", new Object[]{triggerRetryRequest.getId()}));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)retry.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)this.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("Group [{}] is closed, manual execution is not supported.", new Object[]{retry.getGroupName()}));
        Assert.isTrue((boolean)Objects.equals(retry.getTaskType(), SyetemTaskTypeEnum.RETRY.getType()), () -> new SnailJobServerException("No executable tasks"));
        RetryTaskPrepareDTO retryTaskPrepareDTO = com.aizuda.snailjob.server.retry.task.convert.RetryConverter.INSTANCE.toRetryTaskPrepareDTO(retry);
        retryTaskPrepareDTO.setNextTriggerAt(Long.valueOf(DateUtils.toNowMilli()));
        retryTaskPrepareDTO.setRetryTaskExecutorScene(Integer.valueOf(RetryTaskExecutorSceneEnum.MANUAL_RETRY.getScene()));
        retryTaskPrepareDTO.setRetryId(retry.getId());
        ActorRef actorRef = ActorGenerator.retryTaskPrepareActor();
        actorRef.tell((Object)retryTaskPrepareDTO, actorRef);
        return true;
    }

    @Override
    public boolean updateRetryStatus(StatusUpdateRequest requestDTO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)requestDTO.getStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new SnailJobServerException("Retry status error. [{}]", new Object[]{requestDTO.getStatus()});
        }
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryAccess();
        Retry retry = (Retry)retryTaskAccess.one((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getNamespaceId, (Object)this.getNamespaceId())).eq(Retry::getId, (Object)requestDTO.getId()));
        if (Objects.isNull(retry)) {
            throw new SnailJobServerException("Retry task not found");
        }
        retry.setRetryStatus(requestDTO.getStatus());
        if (RetryStatusEnum.RUNNING.getStatus().equals(retryStatusEnum.getStatus())) {
            RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retry.getGroupName(), retry.getSceneName(), this.getNamespaceId());
            WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
            waitStrategyContext.setNextTriggerAt(DateUtils.toNowMilli());
            waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
            waitStrategyContext.setDelayLevel(Integer.valueOf(retry.getRetryCount() + 1));
            WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
            retry.setNextTriggerAt(waitStrategy.computeTriggerTime(waitStrategyContext));
            retry.setDeleted(Long.valueOf(0L));
        }
        if (RetryStatusEnum.FINISH.getStatus().equals(retryStatusEnum.getStatus())) {
            retry.setDeleted(retry.getId());
        }
        retry.setUpdateDt(LocalDateTime.now());
        return retryTaskAccess.updateById((Object)retry) == 1;
    }

    protected abstract String getNamespaceId();
}

