/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.annotation;

import java.util.HashMap;
import java.util.Map;

public enum RoleEnum {
    USER(1, "user"),
    ADMIN(2, "admin");

    private static final Map<Integer, RoleEnum> enumTypeMap;
    private final Integer roleId;
    private final String roleName;

    private RoleEnum(Integer roleId, String roleName) {
        this.roleId = roleId;
        this.roleName = roleName;
    }

    public static Map<Integer, RoleEnum> getEnumTypeMap() {
        return enumTypeMap;
    }

    public static boolean isAdmin(Integer roleId) {
        return ADMIN.getRoleId().equals(roleId);
    }

    public static boolean isUser(Integer roleId) {
        return USER.getRoleId().equals(roleId);
    }

    public Integer getRoleId() {
        return this.roleId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    static {
        enumTypeMap = new HashMap<Integer, RoleEnum>();
        for (RoleEnum roleEnum : RoleEnum.values()) {
            enumTypeMap.put(roleEnum.getRoleId(), roleEnum);
        }
    }
}

