/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.NodeTypeEnum;
import com.aizuda.snailjob.common.core.enums.ServerStatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.DistributeInstance;
import com.aizuda.snailjob.server.common.dto.ServerNodeExtAttrs;
import com.aizuda.snailjob.server.common.dto.UpdateClientInfoDTO;
import com.aizuda.snailjob.server.common.enums.DashboardLineEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.enums.SystemModeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.register.ServerRegister;
import com.aizuda.snailjob.server.common.register.UpdateClientRegister;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.enums.DateTypeEnum;
import com.aizuda.snailjob.server.web.model.request.JobLineQueryVO;
import com.aizuda.snailjob.server.web.model.request.LineQueryVO;
import com.aizuda.snailjob.server.web.model.request.ServerNodeLabelsUpdateRequestVO;
import com.aizuda.snailjob.server.web.model.request.ServerNodeQueryVO;
import com.aizuda.snailjob.server.web.model.request.ServerNodeStatusUpdateRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.DashboardCardResponseVO;
import com.aizuda.snailjob.server.web.model.response.DashboardLineResponseVO;
import com.aizuda.snailjob.server.web.model.response.DashboardRetryLineResponseVO;
import com.aizuda.snailjob.server.web.model.response.ServerNodeResponseVO;
import com.aizuda.snailjob.server.web.service.DashboardService;
import com.aizuda.snailjob.server.web.service.convert.DispatchQuantityResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.JobSummaryResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.RetrySummaryResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.SceneQuantityRankResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.ServerNodeResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.ActivePodQuantityResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.DashboardCardResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetrySummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobSummary;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySummary;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DashboardServiceImpl
implements DashboardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardServiceImpl.class);
    private static final String DASHBOARD_CONSUMER_BUCKET = "/dashboard/consumer/bucket";
    private final ServerNodeMapper serverNodeMapper;
    private final RestTemplate restTemplate;
    private final JobSummaryMapper jobSummaryMapper;
    private final RetrySummaryMapper retrySummaryMapper;
    private final ServerProperties serverProperties;
    private final UpdateClientRegister updateClientRegister;

    @Override
    public DashboardCardResponseVO taskRetryJob() {
        Map.Entry<LocalDateTime, LongSummaryStatistics> map2;
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        ArrayList groupNames = userSessionVO.isUser() ? userSessionVO.getGroupNames() : new ArrayList();
        DashboardCardResponseVO responseVO = new DashboardCardResponseVO();
        DashboardCardResponseDO.RetryTask retryTaskDO = this.retrySummaryMapper.selectRetryTask((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames));
        DashboardCardResponseVO.RetryTask retryTaskVO = RetrySummaryResponseVOConverter.INSTANCE.convert(retryTaskDO);
        responseVO.setRetryTask(retryTaskVO);
        DashboardCardResponseDO.JobTask jobTaskDO = this.jobSummaryMapper.selectJobTask((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.JOB.getType())).eq(JobSummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames));
        DashboardCardResponseVO.JobTask jobTaskVO = JobSummaryResponseVOConverter.INSTANCE.convert(jobTaskDO);
        responseVO.setJobTask(jobTaskVO);
        DashboardCardResponseDO.JobTask workFlowTaskDO = this.jobSummaryMapper.selectJobTask((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.WORKFLOW.getType())).eq(JobSummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames));
        DashboardCardResponseVO.WorkFlowTask workFlowTaskVO = JobSummaryResponseVOConverter.INSTANCE.convertToWorkFlowTask(workFlowTaskDO);
        responseVO.setWorkFlowTask(workFlowTaskVO);
        HashMap<LocalDateTime, DashboardCardResponseVO.RetryTaskBar> retryTaskBarMap = new HashMap<LocalDateTime, DashboardCardResponseVO.RetryTaskBar>();
        for (int i2 = 0; i2 < 7; ++i2) {
            DashboardCardResponseVO.RetryTaskBar retryTaskBar = new DashboardCardResponseVO.RetryTaskBar().setX(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).plusDays(-i2).toLocalDate().toString()).setTaskTotal(0L);
            retryTaskBarMap.put(LocalDateTimeUtil.beginOfDay((LocalDateTime)LocalDateTime.now().minusDays(i2)), retryTaskBar);
        }
        List retryTaskList = this.retrySummaryMapper.selectRetryTaskBarList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames)).orderByDesc(RetrySummary::getId));
        Map<LocalDateTime, LongSummaryStatistics> summaryStatisticsMap = retryTaskList.stream().collect(Collectors.groupingBy(DashboardCardResponseDO.RetryTask::getTriggerAt, Collectors.summarizingLong(i -> i.getMaxCountNum() + i.getRunningNum() + i.getSuspendNum() + i.getFinishNum())));
        for (Map.Entry<LocalDateTime, LongSummaryStatistics> map2 : summaryStatisticsMap.entrySet()) {
            if (!retryTaskBarMap.containsKey(LocalDateTime.of(map2.getKey().toLocalDate(), LocalTime.MIN))) continue;
            DashboardCardResponseVO.RetryTaskBar retryTaskBar = (DashboardCardResponseVO.RetryTaskBar)retryTaskBarMap.get(LocalDateTimeUtil.beginOfDay((LocalDateTime)map2.getKey()));
            retryTaskBar.setX(map2.getKey().toLocalDate().toString()).setTaskTotal(map2.getValue().getSum());
        }
        responseVO.setRetryTaskBarList(new ArrayList<DashboardCardResponseVO.RetryTaskBar>(retryTaskBarMap.values()));
        List activePodQuantityDO = this.serverNodeMapper.selectActivePodCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ServerNode::getNamespaceId, (Collection)Lists.newArrayList((Object[])new String[]{userSessionVO.getNamespaceId(), "DEFAULT_SERVER_NAMESPACE_ID"}))).groupBy(ServerNode::getNodeType));
        map2 = StreamUtils.toMap((Collection)activePodQuantityDO, ActivePodQuantityResponseDO::getNodeType, ActivePodQuantityResponseDO::getTotal);
        Long clientTotal = map2.getOrDefault(NodeTypeEnum.CLIENT.getType(), (LongSummaryStatistics)((Object)Long.valueOf(0L)));
        Long serverTotal = map2.getOrDefault(NodeTypeEnum.SERVER.getType(), (LongSummaryStatistics)((Object)Long.valueOf(0L)));
        responseVO.getOnLineService().setServerTotal(serverTotal);
        responseVO.getOnLineService().setClientTotal(clientTotal);
        responseVO.getOnLineService().setTotal(clientTotal + serverTotal);
        return responseVO;
    }

    @Override
    public DashboardRetryLineResponseVO retryLineList(LineQueryVO queryVO) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        ArrayList groupNames = userSessionVO.isUser() ? userSessionVO.getGroupNames() : new ArrayList();
        DashboardRetryLineResponseVO responseVO = new DashboardRetryLineResponseVO();
        Page pager = new Page((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetrySceneConfig::getGroupName, groupNames);
        pager.setSearchCount(false);
        pager.setTotal(this.retrySummaryMapper.selectRetryTaskListCount((Wrapper)wrapper));
        IPage page = this.retrySummaryMapper.selectRetryTaskList((Wrapper)wrapper, pager);
        List<DashboardRetryLineResponseVO.Task> taskList = JobSummaryResponseVOConverter.INSTANCE.convertList(page.getRecords());
        PageResult<List<DashboardRetryLineResponseVO.Task>> pageResult = new PageResult<List<DashboardRetryLineResponseVO.Task>>(new PageDTO(pager.getCurrent(), pager.getSize(), pager.getTotal()), taskList);
        responseVO.setTaskList(pageResult);
        DateTypeEnum dateTypeEnum = DateTypeEnum.valueOf(queryVO.getType());
        LocalDateTime startDateTime = dateTypeEnum.getStartTime().apply(ObjUtil.isNotNull((Object)queryVO.getStartDt()) ? queryVO.getStartDt() : LocalDateTime.now());
        LocalDateTime endDateTime = dateTypeEnum.getEndTime().apply(ObjUtil.isNotNull((Object)queryVO.getEndDt()) ? queryVO.getEndDt() : LocalDateTime.now());
        List dashboardRetryLinkeResponseDOList = this.retrySummaryMapper.selectRetryLineList(DashboardLineEnum.dateFormat((String)queryVO.getType()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), RetrySummary::getGroupName, (Object)queryVO.getGroupName())).eq(RetrySummary::getNamespaceId, (Object)namespaceId)).between(RetrySummary::getTriggerAt, (Object)startDateTime, (Object)endDateTime));
        List<DashboardLineResponseVO> dashboardLineResponseVOList = DispatchQuantityResponseVOConverter.INSTANCE.convertList(dashboardRetryLinkeResponseDOList);
        dateTypeEnum.getConsumer().accept(dashboardLineResponseVOList);
        dashboardLineResponseVOList.sort(Comparator.comparing(DashboardLineResponseVO::getCreateDt));
        responseVO.setDashboardLineResponseDOList(dashboardLineResponseVOList);
        List rankList = this.retrySummaryMapper.selectDashboardRankList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), RetrySummary::getGroupName, groupNames)).eq(RetrySummary::getNamespaceId, (Object)namespaceId)).ge(RetrySummary::getTriggerAt, (Object)startDateTime)).le(RetrySummary::getTriggerAt, (Object)endDateTime)).groupBy(RetrySummary::getNamespaceId, new SFunction[]{RetrySummary::getGroupName, RetrySummary::getSceneName}));
        List<DashboardRetryLineResponseVO.Rank> ranks = SceneQuantityRankResponseVOConverter.INSTANCE.convertList(rankList);
        responseVO.setRankList(ranks);
        return responseVO;
    }

    @Override
    public DashboardRetryLineResponseVO jobLineList(JobLineQueryVO queryVO) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        ArrayList groupNames = userSessionVO.isUser() ? userSessionVO.getGroupNames() : new ArrayList();
        DashboardRetryLineResponseVO responseVO = new DashboardRetryLineResponseVO();
        Page pager = new Page((long)queryVO.getPage(), (long)queryVO.getSize());
        Integer systemTaskType = SystemModeEnum.JOB.name().equals(queryVO.getMode()) ? SyetemTaskTypeEnum.JOB.getType() : SyetemTaskTypeEnum.WORKFLOW.getType();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getDeleted, (Object)0)).eq(Job::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), Job::getGroupName, groupNames);
        pager.setSearchCount(false);
        pager.setTotal(SystemModeEnum.JOB.name().equals(queryVO.getMode()) ? this.jobSummaryMapper.selectJobTaskListCount((Wrapper)wrapper) : this.jobSummaryMapper.selectWorkflowTaskListCount((Wrapper)wrapper));
        IPage taskIPage = SystemModeEnum.JOB.name().equals(queryVO.getMode()) ? this.jobSummaryMapper.selectJobTaskList((Wrapper)wrapper, pager) : this.jobSummaryMapper.selectWorkflowTaskList((Wrapper)wrapper, pager);
        List<DashboardRetryLineResponseVO.Task> taskList = JobSummaryResponseVOConverter.INSTANCE.convertList(taskIPage.getRecords());
        PageResult<List<DashboardRetryLineResponseVO.Task>> pageResult = new PageResult<List<DashboardRetryLineResponseVO.Task>>(new PageDTO(pager.getCurrent(), pager.getSize(), pager.getTotal()), taskList);
        responseVO.setTaskList(pageResult);
        DateTypeEnum dateTypeEnum = DateTypeEnum.valueOf(queryVO.getType());
        LocalDateTime startDateTime = dateTypeEnum.getStartTime().apply(ObjUtil.isNotNull((Object)queryVO.getStartDt()) ? queryVO.getStartDt() : LocalDateTime.now());
        LocalDateTime endDateTime = dateTypeEnum.getEndTime().apply(ObjUtil.isNotNull((Object)queryVO.getEndDt()) ? queryVO.getEndDt() : LocalDateTime.now());
        List dashboardLineResponseDOList = this.jobSummaryMapper.selectJobLineList(DashboardLineEnum.dateFormat((String)queryVO.getType()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), JobSummary::getGroupName, (Object)queryVO.getGroupName())).eq(JobSummary::getSystemTaskType, (Object)systemTaskType)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).between(JobSummary::getTriggerAt, (Object)startDateTime, (Object)endDateTime));
        List<DashboardLineResponseVO> dashboardLineResponseVOList = DispatchQuantityResponseVOConverter.INSTANCE.convertList(dashboardLineResponseDOList);
        dateTypeEnum.getConsumer().accept(dashboardLineResponseVOList);
        dashboardLineResponseVOList.sort(Comparator.comparing(DashboardLineResponseVO::getCreateDt));
        responseVO.setDashboardLineResponseDOList(dashboardLineResponseVOList);
        List rankList = this.jobSummaryMapper.selectDashboardRankList(systemTaskType, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), JobSummary::getGroupName, (Object)queryVO.getGroupName())).ge(JobSummary::getTriggerAt, (Object)startDateTime)).le(JobSummary::getTriggerAt, (Object)endDateTime)).eq(JobSummary::getSystemTaskType, (Object)systemTaskType)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).groupBy(JobSummary::getNamespaceId, new SFunction[]{JobSummary::getGroupName, JobSummary::getBusinessId}));
        List<DashboardRetryLineResponseVO.Rank> ranks = SceneQuantityRankResponseVOConverter.INSTANCE.convertList(rankList);
        responseVO.setRankList(ranks);
        return responseVO;
    }

    @Override
    public PageResult<List<ServerNodeResponseVO>> pods(ServerNodeQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper serverNodeLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ServerNode::getNamespaceId, (Collection)Lists.newArrayList((Object[])new String[]{UserSessionUtils.currentUserSession().getNamespaceId(), "DEFAULT_SERVER_NAMESPACE_ID"}))).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), ServerNode::getGroupName, (Object)queryVO.getGroupName())).ge(ServerNode::getExpireAt, (Object)LocalDateTime.now().minusSeconds(40L))).orderByDesc(ServerNode::getNodeType);
        PageDTO serverNodePageDTO = (PageDTO)this.serverNodeMapper.selectPage((IPage)pageDTO, (Wrapper)serverNodeLambdaQueryWrapper);
        List<ServerNodeResponseVO> responseVOList = ServerNodeResponseVOConverter.INSTANCE.convertList(serverNodePageDTO.getRecords());
        for (ServerNodeResponseVO serverNodeResponseVO : responseVOList) {
            if (NodeTypeEnum.CLIENT.getType().equals(serverNodeResponseVO.getNodeType())) continue;
            if (ServerRegister.CURRENT_CID.equals(serverNodeResponseVO.getHostId())) {
                serverNodeResponseVO.setConsumerBuckets(DistributeInstance.INSTANCE.getConsumerBucket());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)serverNodeResponseVO.getExtAttrs())) continue;
            ServerNodeExtAttrs serverNodeExtAttrs = (ServerNodeExtAttrs)JsonUtil.parseObject((String)serverNodeResponseVO.getExtAttrs(), ServerNodeExtAttrs.class);
            try {
                String url = NetUtil.getUrl((String)serverNodeResponseVO.getHostIp(), (int)serverNodeExtAttrs.getWebPort(), (String)this.serverProperties.getServlet().getContextPath());
                Result result = (Result)this.restTemplate.getForObject(url.concat(DASHBOARD_CONSUMER_BUCKET), Result.class, new Object[0]);
                List data = (List)result.getData();
                if (!CollUtil.isNotEmpty((Collection)data)) continue;
                serverNodeResponseVO.setConsumerBuckets(data.stream().sorted(Integer::compareTo).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Failed to retrieve consumer group for node [{}:{}].", new Object[]{serverNodeResponseVO.getHostIp(), serverNodeExtAttrs.getWebPort()});
            }
        }
        return new PageResult<List<ServerNodeResponseVO>>(serverNodePageDTO, responseVOList);
    }

    @Override
    public Boolean updatePodsStatus(ServerNodeStatusUpdateRequestVO updateRequestVO) {
        ServerNode serverNode = (ServerNode)this.serverNodeMapper.selectById((Serializable)updateRequestVO.getId());
        Assert.notNull((Object)serverNode, () -> new SnailJobServerException("ServerNode not found."));
        if (serverNode.getNodeType().equals(NodeTypeEnum.SERVER.getType())) {
            return false;
        }
        String labels = serverNode.getLabels();
        Map map = JsonUtil.parseConcurrentHashMap((String)labels);
        ServerStatusEnum statusEnum = ServerStatusEnum.getByType((Integer)updateRequestVO.getServerNodeStatus());
        Assert.notNull((Object)statusEnum, () -> new SnailJobServerException("ServerNodeStatus not existed"));
        map.put((String)SystemConstants.DEFAULT_LABEL.getKey(), statusEnum.getStatus());
        serverNode.setLabels(JsonUtil.toJsonString((Object)map));
        Boolean updated = this.updateLabel(serverNode);
        Assert.isTrue((boolean)updated, () -> new SnailJobServerException("update labels error"));
        return updated;
    }

    @Override
    public Boolean updatePodsLabels(ServerNodeLabelsUpdateRequestVO updateRequestVO) {
        ServerNode serverNode = (ServerNode)this.serverNodeMapper.selectById((Serializable)updateRequestVO.getId());
        if (serverNode.getNodeType().equals(NodeTypeEnum.SERVER.getType())) {
            return false;
        }
        Map toUpdateMap = JsonUtil.parseHashMap((String)updateRequestVO.getLabels());
        String labels = serverNode.getLabels();
        if (StrUtil.isNotBlank((CharSequence)labels)) {
            Map dbMap = JsonUtil.parseHashMap((String)labels);
            toUpdateMap.put((String)SystemConstants.DEFAULT_LABEL.getKey(), (String)dbMap.get(SystemConstants.DEFAULT_LABEL.getKey()));
        }
        serverNode.setLabels(JsonUtil.toJsonString((Object)toUpdateMap));
        return this.updateLabel(serverNode);
    }

    private Boolean updateLabel(ServerNode serverNode) {
        if (this.serverNodeMapper.updateById((Object)serverNode) > 0) {
            UpdateClientInfoDTO clientInfoDTO = new UpdateClientInfoDTO();
            clientInfoDTO.setHostId(serverNode.getHostId());
            clientInfoDTO.setHostIp(serverNode.getHostIp());
            clientInfoDTO.setNamespaceId(serverNode.getNamespaceId());
            clientInfoDTO.setGroupName(serverNode.getGroupName());
            clientInfoDTO.setLabels(serverNode.getLabels());
            return this.updateClientRegister.updateClientInfo(clientInfoDTO);
        }
        return false;
    }

    @Generated
    public DashboardServiceImpl(ServerNodeMapper serverNodeMapper, RestTemplate restTemplate, JobSummaryMapper jobSummaryMapper, RetrySummaryMapper retrySummaryMapper, ServerProperties serverProperties, UpdateClientRegister updateClientRegister) {
        this.serverNodeMapper = serverNodeMapper;
        this.restTemplate = restTemplate;
        this.jobSummaryMapper = jobSummaryMapper;
        this.retrySummaryMapper = retrySummaryMapper;
        this.serverProperties = serverProperties;
        this.updateClientRegister = updateClientRegister;
    }
}

