/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.conversation;

import com.alibaba.dashscope.BaseConversation;
import com.alibaba.dashscope.common.Protocol;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.common.Status;
import com.alibaba.dashscope.conversation.ChatMessage;
import com.alibaba.dashscope.conversation.ConversationParam;
import com.alibaba.dashscope.conversation.ConversationResult;
import com.alibaba.dashscope.conversation.EventType;
import com.alibaba.dashscope.conversation.rpc.ConversationHttpRpc;
import com.alibaba.dashscope.conversation.rpc.ConversationRpc;
import com.alibaba.dashscope.conversation.rpc.ConversationWebsocketRpc;
import com.google.common.collect.Lists;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conversation
implements BaseConversation {
    private static final Logger log = LoggerFactory.getLogger(Conversation.class);
    private final ConversationRpc conversationRpc;
    private long observerTimeout = 30L;
    private final List<ChatMessage> history = Lists.newCopyOnWriteArrayList();

    public Conversation() {
        this.conversationRpc = new ConversationHttpRpc();
    }

    public Conversation(String protocol) {
        this.conversationRpc = Protocol.WEBSOCKET.getValue().equals(protocol) ? new ConversationWebsocketRpc() : new ConversationHttpRpc();
    }

    @Override
    public void call(final ConversationParam param, final ResultCallback<ConversationResult> callback) {
        if (param.getHistory() == null) {
            param.setHistory(this.history);
        }
        class ReactCallback
        extends ResultCallback<ConversationResult> {
            ReactCallback() {
            }

            @Override
            public void onOpen(Status status) {
                callback.onOpen(status);
            }

            @Override
            public void onEvent(String type, ConversationResult message) {
                if (EventType.TASK_FINISHED.getValue().equals(type) && message != null) {
                    Conversation.this.history.add(((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.USER.getValue())).payload(param.getPrompt())).build());
                    Conversation.this.history.add(((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.BOT.getValue())).payload(message.getMessage().getPayload())).build());
                }
                callback.onEvent(type, message);
            }

            @Override
            public void onClose(Status status) {
                callback.onClose(status);
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }

            @Override
            public void doClose(Status status) {
                callback.doClose(status);
            }
        }
        this.conversationRpc.call(param, new ReactCallback());
    }

    @Override
    public Flowable<ConversationResult> streamCall(final ConversationParam param) {
        if (param.getHistory() == null) {
            param.setHistory(this.history);
        }
        param.setStream(true);
        return Flowable.create(emitter -> {
            class ReactCallback
            extends ResultCallback<ConversationResult> {
                private final FlowableEmitter<ConversationResult> emitter;

                public ReactCallback(FlowableEmitter<ConversationResult> emitter) {
                    this.emitter = emitter;
                }

                @Override
                public void onEvent(String type, ConversationResult message) {
                    if (EventType.RESULT_GENERATED.getValue().equals(type) && param.isStream()) {
                        this.emitter.onNext((Object)message);
                    } else if (EventType.TASK_FINISHED.getValue().equals(type) && message != null) {
                        history.add(((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.USER.getValue())).payload(param.getPrompt())).build());
                        history.add(((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.BOT.getValue())).payload(message.getMessage() == null ? null : message.getMessage().getPayload())).build());
                        this.emitter.onNext((Object)message);
                        this.emitter.onComplete();
                    }
                }

                @Override
                public void onError(Exception e) {
                    this.emitter.onError((Throwable)e);
                }
            }
            this.conversationRpc.call(param, new ReactCallback(emitter));
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).timeout(this.observerTimeout, TimeUnit.SECONDS);
    }

    @Override
    public ConversationResult call(ConversationParam param) {
        if (param.getHistory() == null && !this.history.isEmpty()) {
            param.setHistory(this.history);
        }
        param.setStream(false);
        Flowable flowable = Flowable.create(emitter -> {
            class ReactCallback
            extends ResultCallback<ConversationResult> {
                private final FlowableEmitter<ConversationResult> emitter;

                public ReactCallback(FlowableEmitter<ConversationResult> emitter) {
                    this.emitter = emitter;
                }

                @Override
                public void onEvent(String type, ConversationResult message) {
                    if (EventType.TASK_FINISHED.getValue().equals(type)) {
                        this.emitter.onNext((Object)message);
                        this.emitter.onComplete();
                    }
                }

                @Override
                public void onError(Exception e) {
                    this.emitter.onError((Throwable)e);
                }
            }
            this.conversationRpc.call(param, new ReactCallback((FlowableEmitter<ConversationResult>)emitter));
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).timeout(this.observerTimeout, TimeUnit.SECONDS);
        ConversationResult result = (ConversationResult)flowable.blockingFirst();
        if (result != null) {
            this.history.add((ChatMessage)((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.USER.getValue())).payload(param.getPrompt())).build());
            this.history.add((ChatMessage)((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.BOT.getValue())).payload(result.getMessage().getPayload())).build());
        }
        return result;
    }

    public void setObserverTimeout(long observerTimeout) {
        this.observerTimeout = observerTimeout;
    }

    public List<ChatMessage> getHistory() {
        return this.history;
    }
}

