/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.conversation;

import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.conversation.ChatMessage;
import com.alibaba.dashscope.conversation.ConversationMessageHeader;
import com.alibaba.dashscope.conversation.ConversationMessagePayload;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;

public class ConversationMessage {
    private ConversationMessageHeader header;
    private ConversationMessagePayload payload;

    public static ConversationMessage buildInputMessageWithPrompt(String requestId, String model, String utterance, boolean streaming) {
        ConversationMessage input = new ConversationMessage();
        ConversationMessageHeader header = ConversationMessageHeader.buildInputHeader(requestId, streaming);
        input.setHeader(header);
        ConversationMessagePayload payload = ConversationMessagePayload.buildInputPayload(model, utterance);
        input.setPayload(payload);
        return input;
    }

    private static JsonArray prepareHistory(List<ChatMessage> history, Integer nHistory) {
        if (history == null) {
            history = Lists.newArrayList();
        }
        if (nHistory != null && nHistory != -1 && history.size() >= 2 * nHistory) {
            history = history.subList(history.size() - 2 * nHistory, history.size());
        }
        JsonArray list = new JsonArray();
        String user = null;
        String bot = null;
        for (ChatMessage message : history) {
            if (message.getRole().equals(Role.USER.getValue())) {
                user = message.getPayload();
            } else if (message.getRole().equals(Role.BOT.getValue())) {
                bot = message.getPayload();
            }
            if (user == null || bot == null) continue;
            JsonObject json = new JsonObject();
            json.addProperty(Role.BOT.getValue(), bot);
            json.addProperty(Role.USER.getValue(), user);
            list.add((JsonElement)json);
            user = null;
            bot = null;
        }
        return list;
    }

    public static ConversationMessage buildInputMessageWithHistory(String requestId, String model, String utterance, List<ChatMessage> history, Integer nHistory, JsonObject parameters, boolean streaming, boolean enableDebug) {
        ConversationMessage input = new ConversationMessage();
        ConversationMessageHeader header = ConversationMessageHeader.buildInputHeader(requestId, streaming);
        input.setHeader(header);
        ConversationMessagePayload payload = ConversationMessagePayload.buildInputPayload(model, utterance);
        if (history != null && !history.isEmpty()) {
            payload.getInput().add("history", (JsonElement)ConversationMessage.prepareHistory(history, nHistory));
        }
        payload.getInput().addProperty("debug", Boolean.valueOf(enableDebug));
        payload.setParameters(parameters);
        input.setPayload(payload);
        return input;
    }

    public static ConversationMessage buildMultiModalInputMessageWithHistory(String requestId, String model, String utterance, List<ChatMessage> history, int nHistory, JsonObject parameters, boolean streaming, boolean enableDebug) {
        ConversationMessage input = new ConversationMessage();
        ConversationMessageHeader header = ConversationMessageHeader.buildInputHeader(requestId, streaming);
        input.setHeader(header);
        ConversationMessagePayload payload = ConversationMessagePayload.buildMultiModalInputPayload(model, utterance);
        if (history != null && !history.isEmpty()) {
            payload.getInput().add("history", (JsonElement)ConversationMessage.prepareHistory(history, nHistory));
        }
        payload.getInput().addProperty("debug", Boolean.valueOf(enableDebug));
        payload.setParameters(parameters);
        input.setPayload(payload);
        return input;
    }

    public ConversationMessageHeader getHeader() {
        return this.header;
    }

    public ConversationMessagePayload getPayload() {
        return this.payload;
    }

    public void setHeader(ConversationMessageHeader header) {
        this.header = header;
    }

    public void setPayload(ConversationMessagePayload payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationMessage)) {
            return false;
        }
        ConversationMessage other = (ConversationMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConversationMessageHeader this$header = this.getHeader();
        ConversationMessageHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        ConversationMessagePayload this$payload = this.getPayload();
        ConversationMessagePayload other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversationMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversationMessageHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        ConversationMessagePayload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    public String toString() {
        return "ConversationMessage(header=" + this.getHeader() + ", payload=" + this.getPayload() + ")";
    }
}

