/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.conversation;

import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class ConversationMessagePayload {
    private String model;
    private String task;
    @SerializedName(value="task_group")
    private String taskGroup;
    @SerializedName(value="request_id")
    private String requestId;
    private String function;
    private JsonObject input;
    private JsonObject parameters;
    private JsonObject output;
    private JsonObject usage;

    public static ConversationMessagePayload buildInputPayload(String model, String utterance) {
        ConversationMessagePayload payLoad = new ConversationMessagePayload();
        payLoad.setModel(model);
        payLoad.setTask(Task.TEXT_GENERATION.getValue());
        payLoad.setTaskGroup(TaskGroup.AIGC.getValue());
        payLoad.setFunction(Function.GENERATION.getValue());
        JsonObject userInput = new JsonObject();
        userInput.addProperty("prompt", utterance);
        payLoad.setInput(userInput);
        return payLoad;
    }

    public static ConversationMessagePayload buildMultiModalInputPayload(String model, String utterance) {
        ConversationMessagePayload payLoad = new ConversationMessagePayload();
        payLoad.setModel(model);
        payLoad.setTask(Task.CHAT.getValue());
        payLoad.setTaskGroup(TaskGroup.AIGC.getValue());
        payLoad.setFunction(Function.MULTIMODAL_CHAT.getValue());
        JsonObject userInput = new JsonObject();
        userInput.addProperty("prompt", utterance);
        payLoad.setInput(userInput);
        return payLoad;
    }

    public String getModel() {
        return this.model;
    }

    public String getTask() {
        return this.task;
    }

    public String getTaskGroup() {
        return this.taskGroup;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getFunction() {
        return this.function;
    }

    public JsonObject getInput() {
        return this.input;
    }

    public JsonObject getParameters() {
        return this.parameters;
    }

    public JsonObject getOutput() {
        return this.output;
    }

    public JsonObject getUsage() {
        return this.usage;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public void setTaskGroup(String taskGroup) {
        this.taskGroup = taskGroup;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setInput(JsonObject input) {
        this.input = input;
    }

    public void setParameters(JsonObject parameters) {
        this.parameters = parameters;
    }

    public void setOutput(JsonObject output) {
        this.output = output;
    }

    public void setUsage(JsonObject usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationMessagePayload)) {
            return false;
        }
        ConversationMessagePayload other = (ConversationMessagePayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$task = this.getTask();
        String other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        String this$taskGroup = this.getTaskGroup();
        String other$taskGroup = other.getTaskGroup();
        if (this$taskGroup == null ? other$taskGroup != null : !this$taskGroup.equals(other$taskGroup)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$function = this.getFunction();
        String other$function = other.getFunction();
        if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
            return false;
        }
        JsonObject this$input = this.getInput();
        JsonObject other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        JsonObject this$parameters = this.getParameters();
        JsonObject other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) {
            return false;
        }
        JsonObject this$output = this.getOutput();
        JsonObject other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        JsonObject this$usage = this.getUsage();
        JsonObject other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !this$usage.equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversationMessagePayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        String $taskGroup = this.getTaskGroup();
        result = result * 59 + ($taskGroup == null ? 43 : $taskGroup.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : $function.hashCode());
        JsonObject $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        JsonObject $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        JsonObject $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        JsonObject $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        return result;
    }

    public String toString() {
        return "ConversationMessagePayload(model=" + this.getModel() + ", task=" + this.getTask() + ", taskGroup=" + this.getTaskGroup() + ", requestId=" + this.getRequestId() + ", function=" + this.getFunction() + ", input=" + this.getInput() + ", parameters=" + this.getParameters() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ")";
    }
}

