/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.conversation.qwen;

import com.alibaba.dashscope.common.ErrorType;
import com.alibaba.dashscope.common.Protocol;
import com.alibaba.dashscope.common.Status;
import com.alibaba.dashscope.conversation.ConversationMessage;
import com.alibaba.dashscope.conversation.ConversationMessageStatus;
import com.alibaba.dashscope.conversation.ConversationParam;
import com.alibaba.dashscope.conversation.ConversationResult;
import com.alibaba.dashscope.conversation.qwen.QWenConversationResult;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class QWenConversationParam
extends ConversationParam {
    public static final String QWEN_V1 = "qwen-v1";
    private Integer maxLength;
    private Double topP;
    private boolean enableSearch = false;
    private boolean multiModal;
    private boolean enableDebug;
    private Integer nHistory;

    public JsonObject getParameters() {
        JsonObject json = new JsonObject();
        if (this.topP != null) {
            json.addProperty("top_p", (Number)this.topP);
        }
        if (this.maxLength != null) {
            json.addProperty("max_length", (Number)this.maxLength);
        }
        json.addProperty("M6_SEARCH_IN_FIRST_QUERY", (Number)0);
        json.addProperty("M6_NUM_WEB_SEARCH", (Number)(this.enableSearch ? 5 : 0));
        return json;
    }

    @Override
    public String url() {
        return "/services/aigc/text-generation/generation?request_id=" + this.getMsgId();
    }

    @Override
    public String buildMessageBody(String protocol) {
        ConversationMessage inputMessage = ConversationMessage.buildInputMessageWithHistory(this.getMsgId(), this.getModel(), this.getPrompt(), this.getHistory(), this.getNHistory(), this.getParameters(), this.isStream(), this.isEnableDebug());
        if (this.isMultiModal()) {
            inputMessage = ConversationMessage.buildMultiModalInputMessageWithHistory(this.getMsgId(), this.getModel(), this.getPrompt(), this.getHistory(), this.getNHistory(), this.getParameters(), this.isStream(), this.isEnableDebug());
        }
        if (Protocol.HTTP.getValue().equals(protocol)) {
            JsonObject json = new JsonObject();
            json.addProperty("model", inputMessage.getPayload().getModel());
            json.add("parameters", (JsonElement)inputMessage.getPayload().getParameters());
            json.add("input", (JsonElement)inputMessage.getPayload().getInput());
            return json.toString();
        }
        if (Protocol.WEBSOCKET.getValue().equals(protocol)) {
            return JsonUtils.toJson(inputMessage);
        }
        throw new ApiException(((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)ConversationMessageStatus.builder().code(ErrorType.PROTOCOL_UNSUPPORTED.getValue())).message(protocol)).statusCode(400)).build());
    }

    @Override
    public Class<? extends ConversationResult> resultType() {
        return QWenConversationResult.class;
    }

    private static boolean $default$multiModal() {
        return false;
    }

    private static boolean $default$enableDebug() {
        return false;
    }

    protected QWenConversationParam(QWenConversationParamBuilder<?, ?> b) {
        super(b);
        this.maxLength = ((QWenConversationParamBuilder)b).maxLength;
        this.topP = ((QWenConversationParamBuilder)b).topP;
        this.enableSearch = ((QWenConversationParamBuilder)b).enableSearch;
        this.multiModal = ((QWenConversationParamBuilder)b).multiModal$set ? ((QWenConversationParamBuilder)b).multiModal$value : QWenConversationParam.$default$multiModal();
        this.enableDebug = ((QWenConversationParamBuilder)b).enableDebug$set ? ((QWenConversationParamBuilder)b).enableDebug$value : QWenConversationParam.$default$enableDebug();
        this.nHistory = ((QWenConversationParamBuilder)b).nHistory;
    }

    public static QWenConversationParamBuilder<?, ?> builder() {
        return new QWenConversationParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QWenConversationParam)) {
            return false;
        }
        QWenConversationParam other = (QWenConversationParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnableSearch() != other.isEnableSearch()) {
            return false;
        }
        if (this.isMultiModal() != other.isMultiModal()) {
            return false;
        }
        if (this.isEnableDebug() != other.isEnableDebug()) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$nHistory = this.getNHistory();
        Integer other$nHistory = other.getNHistory();
        return !(this$nHistory == null ? other$nHistory != null : !((Object)this$nHistory).equals(other$nHistory));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QWenConversationParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnableSearch() ? 79 : 97);
        result = result * 59 + (this.isMultiModal() ? 79 : 97);
        result = result * 59 + (this.isEnableDebug() ? 79 : 97);
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $nHistory = this.getNHistory();
        result = result * 59 + ($nHistory == null ? 43 : ((Object)$nHistory).hashCode());
        return result;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Double getTopP() {
        return this.topP;
    }

    public boolean isEnableSearch() {
        return this.enableSearch;
    }

    public boolean isMultiModal() {
        return this.multiModal;
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public Integer getNHistory() {
        return this.nHistory;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setEnableSearch(boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public void setMultiModal(boolean multiModal) {
        this.multiModal = multiModal;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public void setNHistory(Integer nHistory) {
        this.nHistory = nHistory;
    }

    @Override
    public String toString() {
        return "QWenConversationParam(super=" + super.toString() + ", maxLength=" + this.getMaxLength() + ", topP=" + this.getTopP() + ", enableSearch=" + this.isEnableSearch() + ", multiModal=" + this.isMultiModal() + ", enableDebug=" + this.isEnableDebug() + ", nHistory=" + this.getNHistory() + ")";
    }

    private static final class QWenConversationParamBuilderImpl
    extends QWenConversationParamBuilder<QWenConversationParam, QWenConversationParamBuilderImpl> {
        private QWenConversationParamBuilderImpl() {
        }

        @Override
        protected QWenConversationParamBuilderImpl self() {
            return this;
        }

        @Override
        public QWenConversationParam build() {
            return new QWenConversationParam(this);
        }
    }

    public static abstract class QWenConversationParamBuilder<C extends QWenConversationParam, B extends QWenConversationParamBuilder<C, B>>
    extends ConversationParam.ConversationParamBuilder<C, B> {
        private Integer maxLength;
        private Double topP;
        private boolean enableSearch;
        private boolean multiModal$set;
        private boolean multiModal$value;
        private boolean enableDebug$set;
        private boolean enableDebug$value;
        private Integer nHistory;

        public B maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        public B topP(Double topP) {
            this.topP = topP;
            return (B)this.self();
        }

        public B enableSearch(boolean enableSearch) {
            this.enableSearch = enableSearch;
            return (B)this.self();
        }

        public B multiModal(boolean multiModal) {
            this.multiModal$value = multiModal;
            this.multiModal$set = true;
            return (B)this.self();
        }

        public B enableDebug(boolean enableDebug) {
            this.enableDebug$value = enableDebug;
            this.enableDebug$set = true;
            return (B)this.self();
        }

        public B nHistory(Integer nHistory) {
            this.nHistory = nHistory;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "QWenConversationParam.QWenConversationParamBuilder(super=" + super.toString() + ", maxLength=" + this.maxLength + ", topP=" + this.topP + ", enableSearch=" + this.enableSearch + ", multiModal$value=" + this.multiModal$value + ", enableDebug$value=" + this.enableDebug$value + ", nHistory=" + this.nHistory + ")";
        }
    }
}

