/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.conversation.qwen;

import com.alibaba.dashscope.common.ErrorType;
import com.alibaba.dashscope.common.Protocol;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.common.Status;
import com.alibaba.dashscope.conversation.ChatMessage;
import com.alibaba.dashscope.conversation.ConversationMessage;
import com.alibaba.dashscope.conversation.ConversationMessageHeader;
import com.alibaba.dashscope.conversation.ConversationMessagePayload;
import com.alibaba.dashscope.conversation.ConversationMessageStatus;
import com.alibaba.dashscope.conversation.ConversationResult;
import com.alibaba.dashscope.conversation.EventType;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;

public class QWenConversationResult
extends ConversationResult {
    private JsonObject usage;

    @Override
    public void loadFromMessage(String protocol, String message) {
        if (Protocol.HTTP.getValue().equals(protocol)) {
            ConversationMessagePayload payload = JsonUtils.fromJson(message, ConversationMessagePayload.class);
            this.setMessage(payload.getOutput() != null ? (ChatMessage)((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.BOT.getValue())).payload(payload.getOutput().get("text") == null ? null : payload.getOutput().get("text").getAsString())).build() : null);
            this.setUsage(payload.getUsage());
            this.setMsgId(payload.getRequestId());
        } else if (Protocol.WEBSOCKET.getValue().equals(protocol)) {
            ConversationMessage res = JsonUtils.fromJson(message, ConversationMessage.class);
            ConversationMessageHeader header = res.getHeader();
            ConversationMessagePayload payload = res.getPayload();
            JsonObject usage = payload.getUsage();
            if (EventType.TASK_FAILED.getValue().equals(header.getEvent())) {
                throw new ApiException(((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)ConversationMessageStatus.builder().message(header.getErrorMessage())).statusCode(44)).code(header.getErrorName())).msgId(header.getTaskId())).usage(usage)).build());
            }
            this.setEventType(header.getEvent());
            this.setMsgId(header.getTaskId());
            this.setMessage(payload.getOutput() != null ? (ChatMessage)((ChatMessage.ChatMessageBuilder)((ChatMessage.ChatMessageBuilder)ChatMessage.builder().role(Role.BOT.getValue())).payload(payload.getOutput().get("text") == null ? null : payload.getOutput().get("text").getAsString())).build() : null);
            this.setUsage(usage);
        } else {
            throw new ApiException(((ConversationMessageStatus.ConversationMessageStatusBuilder)((ConversationMessageStatus.ConversationMessageStatusBuilder)((Status.StatusBuilder)ConversationMessageStatus.builder().code(ErrorType.PROTOCOL_UNSUPPORTED.getValue())).message(protocol)).statusCode(400)).build());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QWenConversationResult)) {
            return false;
        }
        QWenConversationResult other = (QWenConversationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonObject this$usage = this.getUsage();
        JsonObject other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !this$usage.equals(other$usage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QWenConversationResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JsonObject $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        return result;
    }

    public JsonObject getUsage() {
        return this.usage;
    }

    public void setUsage(JsonObject usage) {
        this.usage = usage;
    }

    @Override
    public String toString() {
        return "QWenConversationResult(super=" + super.toString() + ", usage=" + this.getUsage() + ")";
    }
}

